<?php

include_once 'config.php';

class orders_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    // Example method to get open invoices
    public function getOpenInvoices() {
        $sql = "SELECT 
                    i.order_number, 
                    i.datecaptured, 
                    i.due_date, 
                    i.orderdate,
                    i.total_bill, 
                    i.order_state AS invoice_state, 
                    CASE
                        WHEN i.order_state = 0 THEN
                        'Unpaid Invoice'
                        WHEN i.order_state = 1 THEN
                        'Partially Paid Invoice'
                        WHEN i.order_state = 2 THEN
                        'Paid Invoice'
                        WHEN i.order_state = 3 THEN
                        'Cancelled Invoice'
                    END as invoice_status,
                    c.customer_name,
                    (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as total_paid,
                    total_bill - (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as current_balance
                FROM 
                    saved_orders i
                JOIN 
                    customers c ON i.customer = c.customer_id
                WHERE 
                    i.order_state IN(0,1)
                ORDER BY
                    i.orderdate DESC"; 

        $smtp = $this->link->prepare($sql);
        $smtp -> execute(); 
        $data = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $data;
    }

   
    public function getallInvoices() {
        $sql = "SELECT 
                    i.order_number, 
                    i.datecaptured, 
                    i.due_date, 
                    i.orderdate,
                    i.total_bill, 
                    i.order_state,
                    i.order_state AS invoice_state, 
                    CASE
                        WHEN i.order_state = 0 THEN
                        'Unpaid Invoice'
                        WHEN i.order_state = 1 THEN
                        'Partially Paid Invoice'
                        WHEN i.order_state = 2 THEN
                        'Paid Invoice'
                        WHEN i.order_state = 3 THEN
                        'Cancelled Invoice'
                    END as invoice_status,
                    c.customer_name,
                    (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as total_paid,
                    total_bill - (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as current_balance
                FROM 
                    saved_orders i
                JOIN 
                    customers c ON i.customer = c.customer_id
                ORDER BY 
                    CASE 
                        WHEN i.order_state = 0 THEN 0
                        WHEN i.order_state = 1 THEN 1
                        WHEN i.order_state = 2 THEN 2
                        WHEN i.order_state = 3 THEN 3
                    END
                        ";

        $smtp = $this->link->prepare($sql);
        $smtp -> execute(); 
        $data = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $data;
    }

    public function updateOrderState($invoice_id, $state) {
        $sql = "UPDATE saved_orders SET order_state = :state WHERE order_number = :invoice_id";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':state', $state);
        $stmt->bindParam(':invoice_id', $invoice_id);
        return $stmt->execute();
    }


    public function updateOrderStatewithBalance($invoice_id, $state, $balance) {
        $sql = "UPDATE saved_orders SET order_state = :state WHERE order_number = :invoice_id";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':state', $state);
        $stmt->bindParam(':invoice_id', $invoice_id);
        return $stmt->execute();
    }

    public function getTotalPaymentsForInvoice($invoice_number) {
        $sql = "SELECT COALESCE(SUM(amount_paid),0) as total_paid FROM payments 
                WHERE sale_id = :invoice_number AND payment_state = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':invoice_number', $invoice_number);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row['total_paid'] ?? 0;
    }

    public function getInvoiceTotal($invoice_number) {
        $sql = "SELECT COALESCE(SUM(total_bill),0) as total_bill FROM saved_orders 
                WHERE order_number = :invoice_number";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':invoice_number', $invoice_number);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row['total_bill'] ?? 0;
    }
    
    public function getCancelledInvoices() {
        $sql = "SELECT 
                    i.order_number, 
                    i.datecaptured, 
                    i.due_date, 
                    i.orderdate,
                    i.total_bill, 
                    i.order_state AS invoice_state,
                    cid.date_cancelled,
                    cid.reason,
                    CASE
                        WHEN i.order_state = 0 THEN
                        'Unpaid Invoice'
                        WHEN i.order_state = 1 THEN
                        'Partially Paid Invoice'
                        WHEN i.order_state = 2 THEN
                        'Paid Invoice'
                        WHEN i.order_state = 3 THEN
                        'Cancelled Invoice'
                    END as invoice_status,
                    c.customer_name,
                    (COALESCE((SELECT SUM(amount_paid) FROM payments py WHERE i.order_number = py.sale_id AND payment_state = 1),0)) as total_paid,
                    total_bill - (COALESCE((SELECT SUM(amount_paid) FROM payments py WHERE i.order_number = py.sale_id AND payment_state = 1),0)) as current_balance
                FROM 
                    saved_orders i
                JOIN 
                    customers c ON i.customer = c.customer_id
                LEFT JOIN
                    cancelled_invoices_data cid ON i.order_number = cid.invoice_number
                WHERE 
                    i.order_state = 3"; 

        $smtp = $this->link->prepare($sql);
        $smtp -> execute(); 
        $data = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $data;
    }
    
    public function getClosedInvoices() {
        $sql = "SELECT 
                    i.order_number, 
                    i.datecaptured, 
                    i.due_date, 
                    i.orderdate,
                    i.total_bill, 
                    i.order_state AS invoice_state, 
                    i.date_cancelled,
                    CASE
                        WHEN i.order_state = 0 THEN
                        'Unpaid Invoice'
                        WHEN i.order_state = 1 THEN
                        'Partially Paid Invoice'
                        WHEN i.order_state = 2 THEN
                        'Paid Invoice'
                        WHEN i.order_state = 3 THEN
                        'Cancelled Invoice'
                    END as invoice_status,
                    c.customer_name,
                    (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as total_paid,
                    total_bill - (COALESCE((SELECT SUM(amount_paid) FROM invoice_payments py WHERE i.order_number = py.invoice_number AND payment_state = 1),0)) as current_balance
                FROM 
                    saved_orders i
                JOIN 
                    customers c ON i.customer = c.customer_id
                WHERE 
                    i.order_state = 2"; 

        $smtp = $this->link->prepare($sql);
        $smtp -> execute(); 
        $data = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $data;
    }

    public function cancelInvoiceAndRestoreStock($invoiceNumber, $newState, $reason, $date_cancelled){
        try {
            $this->link->beginTransaction();

            // Step 1: Restore Stock
            $restored = $this->restoreCancelledInvoiceStock($invoiceNumber);
            if (!$restored) {
                throw new Exception("Stock restoration failed for invoice $invoiceNumber");
            }

            // Step 2: Cancel Invoice
            $cancelled = $this->cancelInvoiceStateOnly($invoiceNumber, $newState, $date_cancelled);
            if (!$cancelled) {
                throw new Exception("Invoice cancellation (state update) failed for $invoiceNumber");
            }

            $marked = $this->markSalesOrderAsCancelled($invoiceNumber);
            if (!$marked) {
                throw new Exception("Failed to update sales_order status for invoice $invoiceNumber");
            }


            // (Optional) Log reason here in future
            $this->link->commit();
            return true;

        } catch (Exception $e) {
            $this->link->rollBack();
            error_log("❌ CANCEL ERROR: " . $e->getMessage());
            return false;
        }
    }

    private function restoreCancelledInvoiceStock($invoiceNumber){
        // Step 1: Get all sold items
        $sql = "SELECT product_code, quantity, department FROM sales_order WHERE sales_number = :invoiceNumber";
        $stmt = $this->link->prepare($sql);
        $stmt->execute([':invoiceNumber' => $invoiceNumber]);
        $soldItems = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$soldItems) {
            return false;
        }

        foreach ($soldItems as $item) {
            $productCode = $item['product_code'];
            $qty         = (int) $item['quantity'];
            $locationId  = (int) $item['department'];

            // Get product_id from products table
            $productSql = "SELECT product_id FROM products WHERE product_id = :code LIMIT 1";
            $productStmt = $this->link->prepare($productSql);
            $productStmt->execute([':code' => $productCode]);
            $product = $productStmt->fetch(PDO::FETCH_ASSOC);

            if (!$product) {
                return false;
            }

            $productId = $product['product_id'];

            // Check if it's a branch
            $checkBranchSql = "SELECT branch_id FROM branches WHERE branch_id = :id";
            $checkBranchStmt = $this->link->prepare($checkBranchSql);
            $checkBranchStmt->execute([':id' => $locationId]);
            $isBranch = $checkBranchStmt->fetch();

            if ($isBranch) {
                // Update branch stock
                $updateSql = "UPDATE branch_products SET quantity = quantity + :qty WHERE branch_id = :loc AND product_id = :pid";
            } else {
                // Update warehouse stock
                $updateSql = "UPDATE warehouse_products SET quantity = quantity + :qty WHERE warehouse_id = :loc AND product_id = :pid";
            }

            $updateStmt = $this->link->prepare($updateSql);
            $updateSuccess = $updateStmt->execute([
                ':qty' => $qty,
                ':loc' => $locationId,
                ':pid' => $productId
            ]);

            if (!$updateSuccess) {
                return false; // Stop and fail on first error
            }
        }

        return true; // All stock restored successfully
    }



    private function cancelInvoiceStateOnly($invoiceNumber, $newState, $date_cancelled){
        $sql = "UPDATE saved_orders SET order_state = :order_state, date_cancelled = :date_cancelled WHERE order_number = :invoice_number";
        $stmt = $this->link->prepare($sql);

        $stmt->bindparam(':invoice_number', $invoiceNumber);
        $stmt->bindparam(':order_state', $newState);
        $stmt->bindparam(':date_cancelled', $date_cancelled);
        return $stmt->execute();
        
    }

    private function markSalesOrderAsCancelled($invoiceNumber){
        $sql = "UPDATE sales_order SET status = 0 WHERE sales_number = :invoiceNumber";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([':invoiceNumber' => $invoiceNumber]);
    }


    public function logInvoiceCancellation($invoiceNumber, $userId, $reason, $datecaptured){
        $sql = "INSERT INTO cancelled_invoices_data (invoice_number, cancelled_by, reason, date_cancelled)
                VALUES (:invoice_number, :cancelled_by, :reason, :date_cancelled)";

        $stmt = $this->link->prepare($sql);

        return $stmt->execute([
            ':invoice_number' => $invoiceNumber,
            ':cancelled_by'   => $userId,
            ':reason'         => $reason,
            ':date_cancelled' => $datecaptured
        ]);
    }
}