<?php

include_once 'config.php';

class setup_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }
    

    public function checkProcurement($setting){
        $sql = "SELECT value FROM system_settings WHERE setting = :setting LIMIT 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':setting', $setting, PDO::PARAM_STR);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return true if enabled, false otherwise
        return isset($result['value']) && (int)$result['value'] === 1;
    }

    public function updateSetting($key, $value) {
        $sql = "UPDATE system_settings SET value = :value WHERE setting = :key";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':value', $value, PDO::PARAM_INT);
        $stmt->bindParam(':key', $key, PDO::PARAM_STR);
        return $stmt->execute();
    }

    public function getCompanyDetails(){
        $sql = "SELECT vat_value FROM settings WHERE id = 1 LIMIT 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        return $stmt->fetch();
    }

    public function updateVat($vat){
        $sql = "UPDATE settings SET vat_value = ? WHERE id = 1";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([$vat]);
    }

    public function markAsRead($notification_id){
        $sql = "UPDATE 
                    notifications
                SET 
                    notificaton_state = 1
                WHERE 
                    id = :id";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':id', $notification_id, PDO::PARAM_INT);

        return $stmt->execute();
    }

    public function updateDisplaySettings($username, $column, $value){
        $sql = "UPDATE users SET {$column} = :value WHERE username = :username";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->bindParam(':value', $value, PDO::PARAM_INT);
        return $stmt->execute();
    }






    



    
    
    

    

}