<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
      <style>
  .table .dropdown-menu {
    position: absolute;
    z-index: 9999;
    min-width: 160px;
  }

  .dropdown-menu > li > a {
    padding: 8px 15px;
    display: block;
    color: #333;
    white-space: nowrap;
  }

  .dropdown-menu > li > a:hover {
    background-color: #f5f5f5;
  }
</style>


    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          <?php
            include 'menu_finance.php';
            include_once 'model/stock_model.php';

            $stock_model = new stock_model();
            $categories = $stock_model->getCategories();
            $units = $stock_model->getUnits();

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Product Attributes</h2>
                      <ul class="nav navbar-right panel_toolbox">
                        <li>
                          <a class="dropdown-item" rel="facebox" href="new_category.php">
                            <button class="btn btn-info">New Category</button>
                          </a>
                        </li>
                        <li>
                          <a class="dropdown-item" rel="facebox" href="new_unit.php">
                            <button class="btn btn-info">New Unit</button>
                          </a>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                      <div class="row">
                        <!-- Left Half: Product Categories -->
                        <div class="col-md-6">
                          <div class="card-box table-responsive">
                            <h5><strong>Product Categories</strong></h5>
                            <table class="table table-bordered table-striped">
                              <thead>
                                <tr>
                                  <thead>
                                    <th style="text-align:left">Category Name</th>
                                    <th style="text-align:center">Status</th>
                                    <th style="text-align:center;width:90px;">Action</th>
                                  </thead>
                                </tr>
                              </thead>
                              <tbody>
                                <?php foreach($categories as $cat): ?>
                                  <tr>
                                    <td class="text-left"><?php echo $cat['categoryname']; ?></td>
                                    <td class="text-left 
                                      <?php echo ($cat['category_state'] == 1) ? 'bg-success text-white' : 'bg-warning text-white'; ?>">
                                      <?php echo $cat['category_status']; ?>
                                    </td>
                                    <td class="text-center">
                                      <div class="dropdown">
                                        <a class="dropdown-toggle text-dark" data-toggle="dropdown" href="#" aria-expanded="false">
                                          <i class="fa fa-cog"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                          <li>
                                          <a rel="facebox" class="dropdown-item text-info" href="edit_category.php?id=<?php echo $cat['category_id']; ?>" onclick="closeDropdown(this); return false;">
                                            <i class="fa fa-edit"></i> Edit Category
                                          </a>

                                          </li>
                                          <?php if ($cat['category_state'] == 1): ?>
                                            <li>
                                              <a class="dropdown-item text-warning" href="controllers/category_controller.php?action=deactivate&id=<?php echo $cat['category_id']; ?>">
                                                <i class="fa fa-times-circle"></i> Deactivate Category
                                              </a>
                                            </li>
                                          <?php else: ?>
                                            <li>
                                              <a class="dropdown-item text-success" href="controllers/category_controller.php?action=activate&id=<?php echo $cat['category_id']; ?>">
                                                <i class="fa fa-check-circle"></i> Activate Category
                                              </a>
                                            </li>
                                          <?php endif; ?>
                                          <li>
                                            <a class="dropdown-item text-danger" href="controllers/category_controller.php?action=delete&id=<?php echo $cat['category_id']; ?>" onclick="return confirm('Are you sure you want to delete this category?');">
                                              <i class="fa fa-trash"></i> Delete Category
                                            </a>
                                          </li>
                                        </ul>
                                      </div>
                                    </td>
                                  </tr>
                                <?php endforeach; ?>
                              </tbody>


                            </table>
                          </div>
                        </div>

                        <!-- Right Half: Product Units -->
                        <div class="col-md-6">
                          <div class="card-box table-responsive">
                            <h5><strong>Product Units</strong></h5>
                            <table class="table table-bordered table-striped">
                              <thead>
                                <tr>
                                <thead>
                                    <th style="text-align:left">Unit Name</th>
                                    <th style="text-align:center">Status</th>
                                    <th style="text-align:center;width:90px;">Action</th>
                                </thead>
                                </tr>
                              </thead>
                              <tbody>
                                <?php foreach($units as $unit): ?>
                                <tr>
                                  <td class="text-left"><?php echo $unit['unitname']; ?></td><td class="text-left 
                                      <?php echo ($unit['unit_state'] == 1) ? 'bg-success text-white' : 'bg-warning text-white'; ?>">
                                      <?php echo $unit['unit_status']; ?>
                                    </td>
                                    <td class="text-center">
                                      <div class="dropdown">
                                        <a class="dropdown-toggle text-dark" data-toggle="dropdown" href="#" aria-expanded="false">
                                          <i class="fa fa-cog"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                          <li>
                                          <a rel="facebox" class="dropdown-item text-info" href="edit_unit.php?id=<?php echo $unit['unit_id']; ?>" onclick="closeDropdown(this); return false;">
                                            <i class="fa fa-edit"></i> Edit unit
                                          </a>

                                          </li>
                                          <?php if ($unit['unit_state'] == 1): ?>
                                            <li>
                                              <a class="dropdown-item text-warning" href="controllers/unit_controller.php?action=deactivate&id=<?php echo $unit['unit_id']; ?>">
                                                <i class="fa fa-times-circle"></i> Deactivate Unit
                                              </a>
                                            </li>
                                          <?php else: ?>
                                            <li>
                                              <a class="dropdown-item text-success" href="controllers/unit_controller.php?action=activate&id=<?php echo $unit['unit_id']; ?>">
                                                <i class="fa fa-check-circle"></i> Activate Unit
                                              </a>
                                            </li>
                                          <?php endif; ?>
                                          <li>
                                            <a class="dropdown-item text-danger" href="controllers/unit_controller.php?action=delete&id=<?php echo $unit['unit_id']; ?>" onclick="return confirm('Are you sure you want to delete this Unit?');">
                                              <i class="fa fa-trash"></i> Delete Unit
                                            </a>
                                          </li>
                                        </ul>
                                      </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->

          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>

      <?php
        include_once 'libraries.php';
      ?>
      <script>
  function closeDropdown(link) {
    console.log('Clicked:', link);

    var dropdown = $(link).closest('.dropdown');
    if (dropdown.length) {
      dropdown.removeClass('open'); // Remove Bootstrap 3 dropdown-open class
      dropdown.find('.dropdown-menu').hide(); // Just in case
      console.log('Dropdown forcibly closed.');
    } else {
      console.log('Dropdown not found.');
    }
  }
</script>



    </body> 
  </html>
