<!DOCTYPE html>
    <html lang="en">
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD</title>
        <?php
            include_once 'css_links.php';
        ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/stock_model.php';
                        include_once 'model/branch_model.php';
                        include_once 'model/warehouse_model.php';
                        include_once 'model/transfers_model.php';


                        $stock_model = new stock_model();
                        $branch_model = new branch_model();
                        $warehouse_model = new warehouse_model();
                        $transfers_model = new transfers_model();

                        $orderNumber = $_GET['order_number'];
                        $hasItems = $stock_model->orderHasItems($orderNumber);

                        if($hasItems):
                            $locationData = $hasItems ? $stock_model->getFinalLocation($orderNumber) : null;
                            $originData = $stock_model->getOrderLocation($orderNumber);

                            if($locationData){
                                $stockTo = $locationData['stock_to'];
                                $locationTypeTo = $locationData['location_type_to'];
                                $selectedDestination = $locationTypeTo . '-' . $stockTo;
                                
                            }

                            if ($originData) {
                                $stockFrom = $originData['stock_from'];
                                $locationTypeFrom = $originData['location_type_from'];
                                $selectedLocation = $locationTypeFrom . '-' . $stockFrom;

                            }
                        endif;
                            
                        if (!isset($selectedLocation)) {
                            $selectedLocation = '';
                        }
                        
                        if (!isset($selectedDestination)) {
                            $selectedDestination = '';
                        }
        
                        $branches = $branch_model->getBranches();
                        $warehouses = $warehouse_model->getWarehouses();

                        $orders_list = $transfers_model->getOrderItems($orderNumber);
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                <h3><small>Manage Stock - Transfer Stock </small></h3>
                                </div>
                            </div>

                            <div class="clearfix"></div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <form action="controllers/transfers_controller.php" method="post" >
                                        <select id="location_from" name="location_from" class="form-control" style="width:298px;float:left"
                                            <?php echo $hasItems ? 'disabled' : 'required'; ?>>
                                            <option value="">Select Location</option>

                                            <!-- Warehouses -->
                                            <?php foreach ($warehouses as $warehouse): ?>
                                                <option value="W-<?php echo htmlspecialchars($warehouse['warehouse_id']); ?>"
                                                    <?php echo ($selectedLocation == "W-" . $warehouse['warehouse_id']) ? 'selected' : ''; ?>>
                                                    <?php echo htmlspecialchars($warehouse['warehouse_name']); ?>
                                                </option>
                                            <?php endforeach; ?>

                                            <!-- Branches -->
                                            <!-- <?php //foreach ($branches as $branch): ?>
                                                <option value="B-<?php //echo htmlspecialchars($branch['branch_id']); ?>"
                                                    <?php //echo ($selectedLocation == "B-" . $branch['branch_id']) ? 'selected' : ''; ?>>
                                                    <?php //echo htmlspecialchars($branch['branch_name']); ?>
                                                </option>
                                            <?php //endforeach; ?> -->
                                        </select>

                                        <!-- keep this if you need to submit the location via hidden field when select is disabled -->
                                            <?php if ($hasItems): ?>
                                                <input type="hidden" name="location_from" value="<?php echo htmlspecialchars($selectedLocation); ?>">
                                            <?php endif; ?>

                                        <input type="hidden" name="order_number" value="<?php echo $_GET['order_number']; ?>" />
                        
                                        <select name="product_code" class="form-control" style="width:298px;float:left;margin-left:5px;" id="product_code" required>
                                            <option value="" selected disabled>Select Location First</option>
                                        </select>
                                        
                                        <input type="text" step=".001" name="remaining" id="quantity_remaining" class="form-control" style="width:150px;float:left;margin-left:5px;" readonly>
                                        
                                        <input type="number" step=".001" name="quantity" min="0" placeholder="Qty" autocomplete="off" class="form-control" style="width:150px;float:left;margin-left:5px;" required>
                                        

                                        <select id="final_destination" name="final_destination" class="form-control" style="width:298px;float:left;margin-left:5px;" 
                                            <?php echo $hasItems ? 'disabled' : 'required'; ?>>
                                            <option value="" selected disabled>Select Destination</option>

                                            <!-- Warehouses -->
                                            <!-- <?php //foreach ($warehouses as $warehouse): ?>
                                                <option value="W-<?php //echo htmlspecialchars($warehouse['warehouse_id']); ?>"
                                                        data-type="W-<?php //echo htmlspecialchars($warehouse['warehouse_id']); ?>">
                                                    <?php //echo htmlspecialchars($warehouse['warehouse_name']); ?>
                                                </option>
                                            <?php //endforeach; ?> -->

                                            <!-- Branches -->
                                             <?php foreach ($branches as $branch): ?>
                                                <option value="B-<?php echo htmlspecialchars($branch['branch_id']); ?>"
                                                    <?php echo ($selectedDestination == "B-" . $branch['branch_id']) ? 'selected' : ''; ?>>
                                                    <?php echo htmlspecialchars($branch['branch_name']); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>


                                        <?php if ($hasItems): ?>
                                            <input type="hidden" name="final_destination" value="<?php echo htmlspecialchars($selectedDestination); ?>">
                                        <?php endif; ?>

                                        <input type="hidden" name="receive_stock" value="receive_stock" readonly>

                                        <input type="date" style="width:298px;float:left;margin-left:5px" name="transaction_date" class="form-control" max="<?php echo date('Y-m-d')?>">
                
                                        <Button type="submit" class="btn btn-info" style="width:123px;float:left;margin-left:5px;">Add Item <i class="fa fa-plus-circle"></i></button>

                                    </form>

                                    <table class="table table-sm table-bordered" id="resultTable" data-responsive="table">
                                        <thead>
                                            <tr>
                                                <th style="text-align:center">Remove</th>
                                                <th style="text-align:center">Date</th>
                                                <th style="text-align:center">Product</th> 
                                                <th style="text-align:center">Category</th>
                                                <th style="text-align:center">Location From</th> 
                                                <th style="text-align:center">Destination</th> 
                                                <th style="text-align:center">Unit</th>    
                                                <th style="text-align:center">Qty </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                foreach($orders_list as $row):
                                            ?>

                                            <tr style="font-size: 18px;">
                                                <td style="text-align:center;width:5px">
                                                    <a href="delete_cn_item.php?stock_from=<?php echo $row['stock_from']?>&product_code=<?php echo $row['product_id']?>&order_number=<?php echo $row['transaction']; ?>&id=<?php echo $row['id'];?>&quantity=<?php echo $row['quantity'];?>">
                                                    <Button type="submit" class="btn btn-warning"><i class="fa fa-times"></i></button>
                                                    </a>
                                                </td>
                                                
                                                <td style="text-align: center">
                                                    <?php echo $row['order_date'] ?>
                                                </td>
                                                
                                                <td  style="text-transform:capitalize" ><?php echo $row['product_name']; ?></td>
                                                <td  style="text-transform:capitalize" ><?php echo $row['category']; ?></td>
                                                <td  style="text-transform:capitalize" ><?php echo $row['location_from']; ?></td>
                                                <td  style="text-transform:capitalize" ><?php echo $row['location_to']; ?></td>
                                                <td  style="text-transform:capitalize;text-align:center" ><?php echo $row['product_unit'] ?></td>
                                                <td style="text-align:center;"> <?php echo $row['quantity'];?></td>
                                            </tr>
                            
                                                <?php
                                                    endforeach;
                                                ?>
                                        </tbody>
                                    </table>
                                    <br>

                                    <!-- <a rel="facebox" href="complete_order.php?order_id=<?php //echo $_GET['order_id']?>"><button style="float:right;margin-right:10px;font-family:Times New Roman;text-transform: uppercase;font-size: 18px;" class="btn btn-success btn-large">COMPLETE ORDER <i class="fa fa-list"></i> </button></a> -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                document.addEventListener('DOMContentLoaded', function () {
                    const locationSelect = document.getElementById('location_from');
                    const hiddenLocation = document.querySelector('input[name="location_from"]');

                    // If there are items, use the location from the hidden field
                    if (hiddenLocation) {
                        const locationValue = hiddenLocation.value;
                        if (locationValue) {
                            populateProductsByLocation(locationValue);
                        }
                    }

                    // Handle change event when user selects a location
                    locationSelect.addEventListener('change', function () {
                        const locationValue = this.value;
                        if (!locationValue) return;

                        // Clear quantity_remaining field
                        const quantityField = document.getElementById('quantity_remaining');
                        quantityField.value = '';
                        quantityField.required = true;

                        // Populate products based on the selected location
                        populateProductsByLocation(locationValue);
                    });

                    function populateProductsByLocation(locationValue) {
                        const [type, id] = locationValue.split('-');

                        fetch('get_products_by_location.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                            body: `location_type=${type}&location_id=${id}`
                        })
                        .then(response => response.json())
                        .then(data => {
                            const productSelect = document.getElementById('product_code');
                            productSelect.innerHTML = '<option value="" disabled selected>Select Product</option>';
                            data.forEach(product => {
                                const opt = document.createElement('option');
                                opt.value = product.product_id || product.product_code;
                                opt.textContent = product.product_name;
                                productSelect.appendChild(opt);
                            });
                        });
                    }
                });


                $(document).ready(function() {
                    $('#product_code').on('change', function() {
                        let productCode = $(this).val();
                        let location = $('#location_from').val();

                        if (productCode && location) {
                            $.ajax({
                                url: 'get_quantity_remaining.php',
                                type: 'POST',
                                dataType: 'json',
                                data: {
                                    product_code: productCode,
                                    location: location
                                },
                                success: function(response) {
                                    $('#quantity_remaining').val(response.remaining).prop('required', true);
                                },
                                error: function() {
                                    alert('Error fetching remaining quantity');
                                    $('#quantity_remaining').val('').prop('required', true);
                                }
                            });
                        } else {
                            $('#quantity_remaining').val('').prop('required', true);
                        }
                    });
                });
            </script>
            <script>
                document.getElementById('location_from').addEventListener('change', function () {
                    const selectedLocation = this.value;
                    const finalDestSelect = document.getElementById('final_destination');

                    if (!selectedLocation) return;

                    // Enable final destination dropdown if disabled
                    finalDestSelect.disabled = false;

                    // Reset the final destination list
                    const options = finalDestSelect.querySelectorAll('option[data-type]');
                    options.forEach(option => {
                        option.hidden = false;
                        option.disabled = false;
                    });

                    // Hide the option that matches the selected source location
                    const match = finalDestSelect.querySelector(`option[data-type="${selectedLocation}"]`);
                    if (match) {
                        match.disabled = true;
                        match.hidden = true;
                    }

                    // Reset the selection
                    finalDestSelect.value = '';
                });
            </script>
        </body>
    </html> 