<?php
	session_start();

	include_once 'model/users_model.php';
    include_once 'model/employees_model.php';

    $employees_model = new employees_model();
	$users_model = new users_model();

	$user = $_GET['username'];
	$enployee_code = $_GET['employee_code'];
	
	$employeeDetails = $employees_model->getEmployeeDetails($enployee_code);
	$email = $employeeDetails['email_address'];
	$employee_name = $employeeDetails['fullname'];
    

    require_once 'vendor/phpmailer/phpmailer/src/Exception.php';
    require_once 'vendor/phpmailer/phpmailer/src/PHPMailer.php';
    require_once 'vendor/phpmailer/phpmailer/src/SMTP.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;


	function generatePassword($length = 8) {
		if ($length < 4) {
			return "Password length should be at least 4 characters.";
		}
		
		$letters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$numbers = '123456789';
		$special = '#';
		
		$pass = '';
		
		// Ensure at least two numbers and one special character
		$pass .= $numbers[rand(0, strlen($numbers) - 1)]; // Add first number
		$pass .= $numbers[rand(0, strlen($numbers) - 1)]; // Add second number
		$pass .= $special; // Add the special character
		
		// Fill the remaining length of the password with random letters
		$remainingLength = $length - 3; // Subtract the three mandatory characters
		
		$allCharacters = $letters . $numbers . $special;
		for ($i = 0; $i < $remainingLength; $i++) {
			$pass .= $allCharacters[rand(0, strlen($allCharacters) - 1)];
		}
		
		// Shuffle the password to randomize the positions of numbers and special character
		return str_shuffle($pass);
	}
	
	// Generate the user's password
	$pass = generatePassword();
	
	try {
        $mail = new PHPMailer(true);
        $mail->isSMTP();
        $mail->Host       = 'llgolf.smartplus-mw.com';
        $mail->SMTPAuth   = true;
        $mail->SMTPDebug  = 0;
        $mail->Username   = 'noreply@smartplus-mw.com';
        $mail->Password   = '#2024!@EMAIL';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        $mail->setFrom('noreply@smartplus-mw.com', 'Powertex Ltd');
        $mail->addAddress($email, $employee_name); // Recipient email

        $mail->isHTML(true);
        $mail->Subject = 'Password Changed';
        $mail->Body    = "<h1>Dear $employee_name,</h1>
                        <p>Your password has been changed.</p>
                        <p><b>Username:</b> $user</p>
                        <p><b>New Password:</b> $pass</p>
                        <p>Please change your password after logging in for security reasons.</p>
                        <p>Email generated from Smart Plus Essentials.</p>";

        // Attempt to send the email
        if ($mail->send()) {
            // Only hash and update the password if email was sent successfully
            $hashed_password = password_hash($pass, PASSWORD_BCRYPT);
            $users_model->changePassword($user, $hashed_password);

            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'Password has been successfully changed <br>and email sent to the following address '.$email
            ];
        } else {
            // Email sending failed, do NOT change the password
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED!',
                'message' => "Failed to send change password, Try again."
            ];
        }

        header("Location: system_users.php");
        exit();

    } catch (Exception $e) {
        // Exception occurred, do NOT change the password
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED!',
            'message' => "An error occurred while sending email: {$mail->ErrorInfo}"
        ];
        header("Location: system_users.php");
        exit();
    }



?>