<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          
          <?php
            include 'menu_finance.php';
            include_once 'model/customers_model.php';

            $customers_model = new customers_model();   
            $customers = $customers_model->getCustomersFiltered([], 2); // Get all pending customers

            

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="page-title">
                <div class="title_left">
                  <h3><small>View Customer Pending Approval Requests</small></h3>
                </div>

                <div class="title_right">
                  
                </div>
              </div>
              <div class="clearfix"></div>
              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Manage Customers</h2>
                      <ul class="nav navbar-right panel_toolbox d-flex align-items-center" style="gap: 10px;">
                      
                        <li>
                          <button class="btn btn-info" onclick="history.back();">
                            <i class="fa fa-arrow-left"></i> Back
                          </button>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
  <div class="row">
    <div class="col-sm-12">
      <?php if(count($customers) > 0): ?>
      <table class="table table-bordered table-striped" id="pendingCustomersTable">
        <thead>
          <tr>
            <th>#</th>
            <th>Customer Name</th>
            <th>Type</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Location</th>
            <th>Total Invoiced</th>
            <th>Total Paid</th>
            <th>Outstanding</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($customers as $index => $c): ?>
            <tr>
              <td class="align-middle"><?= $index + 1 ?></td>
              <td class="align-middle"><?= htmlspecialchars($c['customer_name']) ?></td>
                <td class="align-middle"><?= htmlspecialchars($c['type_customer']) ?></td>
                <td class="align-middle"><?= htmlspecialchars($c['phone']) ?></td>
                <td class="align-middle"><?= htmlspecialchars($c['email']) ?></td>
                <td class="align-middle"><?= htmlspecialchars($c['location']) ?></td>
                <td class="text-right align-middle"><?= number_format($c['total_invoiced'], 2) ?></td>
                <td class="text-right align-middle"><?= number_format($c['total_paid'], 2) ?></td>
                <td class="text-right align-middle"><?= number_format($c['outstanding_balance'], 2) ?></td>
                <td class="d-flex gap-1">
                <form method="POST" action="controllers/customer_controller.php">
                  <input type="hidden" name="action" value="approve_customer">
                  <input type="hidden" name="customer_id" value="<?= $c['customer_id'] ?>">
                  <button class="btn btn-success btn-sm" type="submit">
                    <i class="fa fa-check"></i> Approve
                  </button>
                </form>

                <form method="POST" action="controllers/customer_controller.php" class="deny-customer-form">
                    <input type="hidden" name="action" value="deny_customer">
                    <input type="hidden" name="customer_id" value="<?= $c['customer_id'] ?>">
                    <button class="btn btn-danger btn-sm" type="button" onclick="confirmDeny(this)">
                        <i class="fa fa-times"></i> Deny
                    </button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <?php else: ?>
        <div class="alert alert-info">No pending customers found.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
  $(document).ready(function() {
      $('#pendingCustomersTable').DataTable({
        "order": [[0, "asc"]],
        responsive: true
      });
  });
</script>

                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->
          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>
      <?php
        include_once 'libraries.php';
      ?>
      <script>
            function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
          }
        
            function confirmDeny(button) {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "This will change customer type to Walk-in customers",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, very sure!',
                    cancelButtonText: 'Cancel',
                    reverseButtons: true // This swaps the positions: Cancel left, Confirm right
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Submit the form
                        button.closest('form').submit();
                    }
                });
            }


        </script>
      
    
    </body>
  </html>