<?php

session_start();
date_default_timezone_set('Africa/Blantyre');

include_once 'model/employees_model.php';

$employees_model = new employees_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $postName = trim($_POST['post_name']);
    $departmentId = $_POST['department'];
    $operator = $_SESSION['sess_employeecode'];
    $gross_salary = $_POST['gross_salary'];
    $overtime_rate = $_POST['overtime_rate'];
    $datecaptured = date('Y-m-d H:i');

    if (!empty($postName) && !empty($departmentId)) {

        $count = $employees_model->checkPost($postName);

        if ($count > 0) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => "Post already exists."
            ];
            header('location:manage_posts.php');
            exit();
        } else {
            $saved = $employees_model->savePost($postName, $departmentId, $gross_salary, $overtime_rate, $datecaptured, $operator);

            if ($saved) {
                $_SESSION['notification'] = [
                    'type' => 'info',
                    'title' => 'SUCCESS',
                    'message' => "Post added successfully."
                ];
                header('location:manage_posts.php');
                exit();
            } else {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => "Failed to save post."
                ];
                header('location:manage_posts.php');
                exit();
            }
        }
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED',
            'message' => "All fields are required."
        ];
        header('location:manage_posts.php');
        exit();
    }
}
?>
