<?php
session_start();
date_default_timezone_set('Africa/Blantyre');
include_once 'model/warehouse_model.php';

// Collect posted values
$name_warehouse = isset($_POST['name_warehouse']) ? trim($_POST['name_warehouse']) : '';
$location_id    = isset($_POST['location']) ? $_POST['location'] : '';
$warehouse_code = isset($_POST['warehouse_code']) ? $_POST['warehouse_code'] : '';

$errors = [];

if (empty($name_warehouse)) {
    $errors[] = "Warehouse name is required.";
}

if (empty($location_id)) {
    $errors[] = "Location must be selected.";
}



if (empty($errors)) {
    $warehouse_model = new warehouse_model();

    $warehouse_id = $warehouse_model->generateNextID();


    // Check if location already has a warehouse
    if ($warehouse_model->doesLocationAlreadyHaveWarehouse($location_id)) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Failed',
            'message' => 'This location already has a warehouse assigned.'
        ];
        header("Location: manage_warehouses.php");
        exit;
    }


    // All checks passed, save the warehouse
    $warehouse_data = [
        'warehouse_id' => $warehouse_id,
        'warehouse_name' => $name_warehouse,
        'location' => $location_id,
        'warehouse_code' => $warehouse_code,
        'datecaptured' => date('Y-m-d H:i:s'),
        'operator' => $_SESSION['sess_employeecode']
    ];

    $saved = $warehouse_model->saveWarehouse($warehouse_data);

    $_SESSION['notification'] = $saved
        ? ['type' => 'success', 'title' => 'Saved', 'message' => 'Warehouse added successfully.']
        : ['type' => 'error', 'title' => 'Failed', 'message' => 'Failed to save warehouse.'];

    header("Location: manage_warehouses.php");
    exit;
} else {
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Validation Error',
        'message' => implode('<br>', $errors)
    ];
    header("Location: add_warehouse.php");
    exit;
}
?>
