<!DOCTYPE html>
    <html lang="en">
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD</title>
        <?php
            include_once 'css_links.php';
        ?>
            <style>
                .switch-large {
                    position: relative;
                    display: inline-block;
                    width: 70px;
                    height: 34px;
                }

                .switch-large input {
                    opacity: 0;
                    width: 0;
                    height: 0;
                }

                .switch-large .slider {
                    position: absolute;
                    cursor: pointer;
                    background-color: #dc3545; /* red when off */
                    transition: .4s;
                    border-radius: 34px;
                    top: 0;
                    left: 0;
                    right: 0;
                    bottom: 0;
                }

                .switch-large .slider:before {
                    position: absolute;
                    content: "";
                    height: 26px;
                    width: 26px;
                    left: 4px;
                    bottom: 4px;
                    background-color: white;
                    transition: .4s;
                    border-radius: 50%;
                }

                .switch-large input:checked + .slider {
                    background-color: #28a745; /* green when on */
                }

                .switch-large input:checked + .slider:before {
                    transform: translateX(36px);
                }

                .slider.round {
                    border-radius: 34px;
                }

            </style>


        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
                    <?php
                        include 'menu_finance.php';

                        include_once 'model/setup_model.php';

                        $setup_model  = new setup_model();
                        $procure_setting = 'procurement';
                        $check_procurement = $setup_model->checkProcurement($procure_setting);

                        $companyDetails = $setup_model->getCompanyDetails();
                        $vat_value = $companyDetails['vat_value']*100;



                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center">
                                            <!-- Left Title -->
                                            <h2 class="mb-0">Powertex limited</h2>
                                            <!-- Center Title -->
                                            <h2 class="mb-0 text-center flex-grow-1">System Management</h2>
                                            
                                        </div>
                                    </div>
                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="card-box table-responsive">

                                                    <!-- Search Box -->
                                                    <div class="mb-4">
                                                        <input type="text" id="setting-search" class="form-control" placeholder="🔍 Search Settings..." onkeyup="filterSettings()">
                                                    </div>

                                                    <!-- Settings Buttons Inline -->
                                                    <div class="row setting-item mb-4">

                                                        <!-- Excel Template Button -->
                                                        <div class="col-md-auto mb-2">
                                                            <h6><i class="fa fa-file-excel text-success"></i> Product Template</h6>
                                                            <form action="generate_product_template.php" method="post">
                                                                <button type="submit" class="btn btn-outline-success w-100">
                                                                    <i class="fa fa-download"></i> Excel Template
                                                                </button>
                                                            </form>
                                                        </div>

                                                        <!-- Procurement Toggle -->
                                                        <div class="col-md-auto mb-2">
                                                            <h6><i class="fa fa-cogs text-info"></i> Procurement Module</h6>
                                                            <form id="procurement-toggle-form" method="post" action="controllers/settings_controller.php" class="d-flex align-items-center">
                                                                <input type="hidden" name="action" value="change_setting">
                                                                <input type="hidden" name="setting_key" value="procurement">
                                                                <input type="hidden" name="value" id="procurement-value" value="<?= $check_procurement ? '1' : '0' ?>">

                                                                <span class="badge <?= $check_procurement ? 'badge-success' : 'badge-danger' ?> mr-2" id="procurement-status">
                                                                    <?= $check_procurement ? 'ON' : 'OFF' ?>
                                                                </span>

                                                                <label class="switch-large">
                                                                    <input type="checkbox" id="procurement_enabled"
                                                                        <?= $check_procurement ? 'checked' : '' ?>>
                                                                    <span class="slider round"></span>
                                                                </label>
                                                            </form>

                                                        </div>

                                                        <!-- VAT Setting -->
                                                        <div class="col-md-auto mb-2 setting-item">
                                                            <h6><i class="fa fa-percent text-warning"></i> VAT (%)</h6>

                                                            <form method="post"
                                                                action="controllers/settings_controller.php"
                                                                class="form-inline"
                                                                id="vat-form">

                                                                <input type="hidden" name="action" value="update_vat">

                                                                <input type="number"
                                                                    step="0.00001"
                                                                    min="0"
                                                                    max="100"
                                                                    class="form-control mr-2"
                                                                    name="vat"
                                                                    id="vat-input"
                                                                    value="<?= htmlspecialchars($vat_value) ?>"
                                                                    readonly
                                                                    style="width: 100px;">

                                                                <button type="button"
                                                                        class="btn btn-outline-primary mr-2"
                                                                        id="vat-edit-btn">
                                                                    Edit
                                                                </button>

                                                                <button type="button"
                                                                        class="btn btn-outline-secondary d-none"
                                                                        id="vat-cancel-btn">
                                                                    Cancel
                                                                </button>

                                                            </form>

                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                function filterSettings() {
                    const input = document.getElementById("setting-search").value.toLowerCase();
                    const settings = document.querySelectorAll(".setting-item");

                    settings.forEach(item => {
                        item.style.display = item.innerText.toLowerCase().includes(input) ? "block" : "none";
                    });
                }
            </script>
            <script>
                document.getElementById('procurement_enabled')?.addEventListener('change', function (e) {
                    const isChecked = this.checked;
                    const statusLabel = document.getElementById('procurement-status');
                    const hiddenInput = document.getElementById('procurement-value');
                    const form = document.getElementById('procurement-toggle-form');

                    e.preventDefault(); // prevent auto form submission

                    Swal.fire({
                        title: 'Are you sure?',
                        text: `You want to ${isChecked ? 'enable' : 'disable'} Procurement Module.`,
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Update hidden value before submit
                            hiddenInput.value = isChecked ? '1' : '0';
                            form.submit();
                        } else {
                            // Revert toggle visually
                            this.checked = !isChecked;
                        }
                    });
                });
            </script>
            <script>
document.addEventListener('DOMContentLoaded', function () {

    const input = document.getElementById('vat-input');
    const editBtn = document.getElementById('vat-edit-btn');
    const cancelBtn = document.getElementById('vat-cancel-btn');
    const form = document.getElementById('vat-form');

    let originalValue = input.value;

    editBtn.addEventListener('click', function () {

        if (input.hasAttribute('readonly')) {
            // 🔹 Enter edit mode
            originalValue = input.value;
            input.removeAttribute('readonly');
            input.focus();

            editBtn.textContent = 'Save';
            editBtn.classList.remove('btn-outline-primary');
            editBtn.classList.add('btn-success');

            cancelBtn.classList.remove('d-none');

        } else {
            // 🔹 Save
            Swal.fire({
                title: 'Save changes?',
                text: 'This will update the VAT value system-wide.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, save',
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        }
    });

    cancelBtn.addEventListener('click', function () {
        // 🔹 Cancel edit
        input.value = originalValue;
        input.setAttribute('readonly', true);

        editBtn.textContent = 'Edit';
        editBtn.classList.remove('btn-success');
        editBtn.classList.add('btn-outline-primary');

        cancelBtn.classList.add('d-none');
    });

});
</script>





        </body>
    </html>
