<?php
include_once 'model/transfers_model.php';  // Assuming you have a sales model
$transfers_model = new transfers_model();
if(isset($_GET['start']) && isset($_GET['end'])){
    $start = $_GET['start'];
    $end = $_GET['end'];
} else {
    $start = date('Y-m-1'); // Default to today
    $end = date('Y-m-t');   // Default to today
}
$transfers = $transfers_model->getTransfers($start, $end); 
date_default_timezone_set('Africa/Blantyre');
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Manage Transfers</title>
        <?php
            include_once 'css_links.php';
        ?>
    </head>

    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php
                    include 'menu_finance.php';
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            <div class="title_left">
                                <h3><small>Sales </small></h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 ">
                                <div class="x_panel">
                                    <div class="x_title" style="display:flex; align-items:center; gap:15px;">

                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Transfers</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div style="flex:1; text-align:center;">
                                            <h5 class="mb-0">Transfers Overview</h5>
                                        </div>


                                       <form method="GET" class="form-inline" style="display:flex; align-items:center; gap:8px; margin:0;">
                                            <div class="form-group mr-2">
                                                <label for="start" class="mr-1">Start Date</label>
                                                <input 
                                                    type="date" 
                                                    name="start" 
                                                    id="start" 
                                                    class="form-control form-control-sm"
                                                    value="<?= htmlspecialchars($start) ?>"
                                                    required
                                                >
                                            </div>

                                            <div class="form-group mr-2">
                                                <label for="end" class="mr-1">End Date</label>
                                                <input 
                                                    type="date" 
                                                    name="end" 
                                                    id="end" 
                                                    class="form-control form-control-sm"
                                                    value="<?= htmlspecialchars($end) ?>"
                                                    required
                                                >
                                            </div>

                                            <button type="submit" class="btn btn-primary btn-sm">
                                                <i class="fa fa-filter"></i> Filter
                                            </button>
                                        </form>


                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <a class="dropdown-item" href="javascript:void(0);" onclick="history.back();">
                                                    <button class="btn btn-secondary btn-sm">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>

                                    

                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="card-box table-responsive">                                                          
                                                    <?php if (!empty($transfers)) { ?>
                                                        <table id="transfersTable" class="table table-bordered table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Transaction Date</th>
                                                                    <th>Reference No</th>
                                                                    <th>Waybill No</th>
                                                                    <th>Supplier Name</th>
                                                                    <th>Number of Items</th>
                                                                    <th>Destination</th>
                                                                    <th>Transport Mode</th>
                                                                    <th>Transfer State</th>
                                                                    <th>Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($transfers as $transfer) { ?>
                                                                    <tr>
                                                                        <td><?php echo date('d F,Y', strtotime($transfer['shipment_date'])); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['reference_no']); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['waybill_number']); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['supplier_name']); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['num_items']); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['receiver_name']); ?></td>
                                                                        <td><?php echo htmlspecialchars($transfer['transport_mode']); ?></td>
                                                                        <td class="<?php
                                                                            // Adding color-coding based on sale status
                                                                            $status = $transfer['transfer_state'];

                                                                            if($status == 0){
                                                                                echo 'bg-danger text-white';
                                                                            }elseif($status == 1){
                                                                                echo 'bg-info text-white';
                                                                            }else{
                                                                                echo 'bg-success text-white';
                                                                            }
                                                            
                                                                        ?>">
                                                                            <?php echo htmlspecialchars(ucfirst($transfer['transfer_status'])); ?>
                                                                        </td>
                                                                        <td>
                                                                            <a href="shipment_document.php?shipment_id=<?= $transfer['transfer_id'] ?>" class="btn btn-info btn-sm" title="Shipment Invoices">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </a>
                                                                            <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-cog"></i>
                                                                                </button>
                                                                            </a>
                                                                        </td>
                                                                    </tr>
                                                                <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php } else { ?>
                                                        <div class="alert alert-info">
                                                            No Shipment Data is available for the selected dates
                                                        </div>
                                                    <?php } ?>
                                                    
                                                  
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php
                    include_once 'footer.php';
                ?>
            </div>
        </div>

        <?php
            include_once 'libraries.php';
        ?>
        <script>
            function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
        </script>
        <script>
$(document).ready(function () {
    $('#transfersTable').DataTable({
        pageLength: 50,
        lengthChange: true,
        ordering: true,
        searching: true,
        info: true,
        responsive: true,
        order: [[0, 'desc']], // Sort by Transaction Date
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting on Action column
        ]
    });
});
</script>

    </body>
</html>
