<?php session_start(); ?>
<!DOCTYPE html>
<html>
<head>
    <title>Leave Form Test</title>
</head>
<body>
    <h2>Leave Date Range</h2>

    <label>Start Date:</label>
    <input type="date" id="requested_start_date" /><br><br>

    <label>End Date:</label>
    <input type="date" id="requested_end_date" /><br><br>

    <label>Requested Days:</label>
    <input type="text" id="requested_num_days" readonly /><br><br>

    <script>
    document.addEventListener('DOMContentLoaded', function () {
        console.log('🟢 JS DOMContentLoaded running');

        const startInput = document.getElementById('requested_start_date');
        const endInput = document.getElementById('requested_end_date');
        const daysInput = document.getElementById('requested_num_days');

        if (!startInput || !endInput || !daysInput) {
            console.error('❌ One or more elements not found');
            return;
        }

        function calculateDays() {
            console.log('🟡 Date change detected');

            if (startInput.value && endInput.value) {
                const [sy, sm, sd] = startInput.value.split('-');
                const [ey, em, ed] = endInput.value.split('-');

                const start = new Date(sy, sm - 1, sd);
                const end = new Date(ey, em - 1, ed);

                if (!isNaN(start) && !isNaN(end) && end >= start) {
                    const diff = Math.round((end - start) / (1000 * 60 * 60 * 24)) + 1;
                    daysInput.value = diff;
                } else {
                    daysInput.value = '';
                }
            } else {
                daysInput.value = '';
            }
        }

        startInput.addEventListener('input', calculateDays);
        endInput.addEventListener('input', calculateDays);
    });
    </script>
</body>
</html>
