<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Third Party Companies</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php include_once 'css_links.php'; ?>
    </head>
    <body class="nav-md">
        <div class="container body">
            <div class="main_container">
                <?php 
                    include 'menu_finance.php';
                    
                    include_once 'model/company_model.php';

                    $companies_model = new company_model();
                    $companies = $companies_model->getThirdPartyCompanies();
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center">
                                        <div>
                                            <h2 class="mb-0">Third Party Companies</h2>
                                        </div>

                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Manage Third Party Companies & Their Stock</h5>
                                        </div>

                                        <!-- Right side: Back & Add New Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <button class="btn btn-primary btn-sm">
                                                    <a href="add_new_third_party_company.php" rel="facebox" class="text-white">                                                    
                                                        <i class="fa fa-plus-circle"></i> Add New Company
                                                    </a>
                                                </button>
                                            </li>
                                            
                                        </ul>
                                    </div>
                                    <div class="x_content">
                                        <!-- Table displaying third-party company stock data -->
                                        <table class="table table-striped table-bordered" id="third-party">
                                            <thead>
                                                <tr>
                                                    <th>Company Name</th>
                                                    <th>Contact Person</th>
                                                    <th>Phone Number</th>
                                                    <th>Email Address</th>
                                                    <th>Company Location</th>
                                                    <th>Number of Products</th>
                                                    <th>Total Stock Quantity (Units)</th>
                                                    <th>Company Status</th>
                                                    <th style="width: 15%;">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($companies as $company): ?>
                                                    <tr>
                                                        <td><?= htmlspecialchars($company['company_name']) ?></td>
                                                        <td><?= htmlspecialchars($company['contact_person']) ?></td>
                                                        <td><?= htmlspecialchars($company['phone_number']) ?></td>
                                                        <td><?= htmlspecialchars($company['email_address']) ?></td>
                                                        <td><?= htmlspecialchars($company['location_name']) ?></td>
                                                        <td style="text-align: center;"><?= htmlspecialchars($company['total_products']) ?></td>
                                                        <td style="text-align: center;"><?= htmlspecialchars($company['total_stock_quantity']) ?></td>
                                                        
                                                        <?php
                                                            // Directly assign the class based on the status using if-else logic
                                                            if ($company['company_state'] == 1) {
                                                                $class = 'bg-success text-white'; // Green for active
                                                            } elseif ($company['company_state'] == 0) {
                                                                $class = 'bg-warning text-dark'; // Yellow for suspended
                                                            } elseif ($company['company_state'] == 3) {
                                                                $class = 'bg-danger text-white'; // Red for inactive
                                                            } else {
                                                                $class = 'bg-secondary text-white'; // Default gray for other statuses
                                                            }
                                                        ?>
                                                        <td class="<?= $class ?>">
                                                            <?= htmlspecialchars($company['company_status']) ?>
                                                        </td>

                                                        <td>
                                                            <a title="View Products in Company" href="third_party_products.php?company_id=<?= $company['company_id'] ?>" class="btn btn-info btn-sm">
                                                                <i class="fa fa-list"></i>
                                                            </a>
                                                            <a title="View company details" href="third_party_company_details.php?id=<?= $company['company_id'] ?>" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a title="Edit Company Details" href="javascript:void(0);" class="btn btn-warning btn-sm" 
                                                            data-toggle="modal" data-target="#editCompanyModal" 
                                                            onclick="loadCompanyDetails('<?= $company['company_id'] ?>')">
                                                                <i class="fas fa-edit"></i> Edit
                                                            </a>
                                                            
                                                            <a title="Configuration" href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                <button class="btn btn-info btn-sm">
                                                                    <i class="fa fa-cog"></i>
                                                                </button>
                                                            </a>                                    
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->
                <?php 
                    include_once 'footer.php'; 
                ?>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="editCompanyModal" tabindex="-1" role="dialog" 
            aria-labelledby="editCompanyModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editCompanyModalLabel">Edit Company Details</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Company Edit Form -->
                        <form id="editCompanyForm" method="POST" action="controllers/company_controller.php">
                            <!-- Hidden input for company_id -->
                            <input type="hidden" id="company_id" name="company_id" value="" readonly>
                            <input type="hidden" id="action" name="action" value="update_third_party_company_details" readonly>

                            <div class="form-group">
                                <label for="company_name">Company Name</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" required>
                            </div>
                            <div class="form-group">
                                <label for="contact_person">Contact Person</label>
                                <input type="text" class="form-control" id="contact_person" name="contact_person" required>
                            </div>
                            <div class="form-group">
                                <label for="phone_number">Phone Number</label>
                                <input type="text" class="form-control" id="phone_number" name="phone_number" required>
                            </div>
                            <div class="form-group">
                                <label for="email_address">Email Address</label>
                                <input type="email" class="form-control" id="email_address" name="email_address" required>
                            </div>
                            <div class="form-group">
                                <label for="location_name">Location</label>
                                <select name="location" class="form-control" id="location" required>
                                    <!-- Locations will be populated here -->
                                </select>
                            </div>
                            
                            <!-- New field for Company State (Enabled/Disabled) -->
                            <div class="form-group">
                                <label for="company_state">Company State</label>
                                <select name="company_state" class="form-control" id="company_state" required>
                                    <option value="1">Enabled</option>
                                    <option value="0">Disabled</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>


        <?php 
            include_once 'libraries.php'; 
        ?>
        <script>
            $(document).ready(function () {
            let table = $('#third-party').DataTable({
                responsive: true,
                ordering: true,
                pageLength: 25,
                columnDefs: [{
                targets: -1,
                width: "250px",
                className: "text-center",
                orderable: false
                }]
            });

            // Search across all columns using external input
            $('#search_query').on('keyup', function () {
                table.search(this.value).draw();
            });
            });
        </script>
        <script>
            function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
            function loadCompanyDetails(company_id) {
                // Ensure company_id is treated as a string
                company_id = String(company_id);

                $.ajax({
                    url: 'get_third_party_company_details.php',  // File to fetch company details
                    method: 'POST',
                    data: {
                        company_id: company_id  // Send the company_id as a string
                    },
                    success: function(response) {
                        const company = JSON.parse(response);

                        if (company.error) {
                            alert(company.error);
                        } else {
                            // Populate modal fields with company details
                            $('#company_id').val(company.company_id);
                            $('#company_name').val(company.company_name);
                            $('#contact_person').val(company.contact_person);
                            $('#phone_number').val(company.phone_number);
                            $('#email_address').val(company.email_address);
                            
                            // Populate the location dropdown
                            populateLocationDropdown(company.location_id);

                            // Set the company state (Enabled/Disabled)
                            $('#company_state').val(company.company_state);
                        }
                    },
                    error: function(error) {
                        console.error('Error fetching company details:', error);
                    }
                });
            }

            // Function to populate the location dropdown
            function populateLocationDropdown(currentLocationId) {
                $.ajax({
                    url: 'get_locations.php',  // New file to fetch locations
                    method: 'POST',
                    success: function(response) {
                        const locations = JSON.parse(response);
                        const locationSelect = $('#location');
                        
                        // Empty the location dropdown
                        locationSelect.empty();

                        // Loop through locations and add them to the dropdown
                        locations.forEach(function(location) {
                            // Skip the current location
                            if (location.loc_id !== currentLocationId) {
                                locationSelect.append(new Option(location.location_name, location.loc_id));
                            }
                        });
                    },
                    error: function(error) {
                        console.error('Error fetching locations:', error);
                    }
                });
            }



        </script>

        

    </body>
</html>
