<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Third Party Companies </small></h3>
                                </div>

                                <div class="title_right">
                    
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>Third party company details</h2>
                                            <ul class="nav navbar-right panel_toolbox">
                                                <li>
                                                    <button class="btn btn-warning btn-sm" onclick="history.back()">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </li>
                                            </ul>
                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">
                                            <?php
                                                // Fetch the third-party company details from the DB
                                                include_once 'model/companies_model.php';

                                                $companies_model = new companies_model();

                                                $company_id = isset($_GET['id']) ? trim($_GET['id']) : '';
                                                $company = $companies_model->getThirdPartyCompanyDetails($company_id);
                                                $products = $companies_model->getThirdPartyCompanyProducts($company_id);
                                            ?>

                                            <?php if ($company): ?>
                                                <div class="card shadow mb-4 border-left-primary">
                                                    <div class="card-header bg-success text-white">
                                                        <h4 class="mb-0">
                                                            <i class="fa fa-industry"></i> <?= htmlspecialchars($company['company_name']) ?>
                                                        </h4>
                                                    </div>

                                                    <div class="card-body">
                                                        <div class="row">
                                                            <div class="col-md-6 mb-2">
                                                                <strong>Contact Person:</strong><br>
                                                                <?= htmlspecialchars($company['contact_person']) ?>
                                                            </div>
                                                            <div class="col-md-6 mb-2">
                                                                <strong>Phone:</strong><br>
                                                                <?= htmlspecialchars($company['contact_number']) ?>
                                                            </div>
                                                            <div class="col-md-6 mb-2">
                                                                <strong>Email:</strong><br>
                                                                <?= htmlspecialchars($company['email']) ?>
                                                            </div>
                                                            <div class="col-md-6 mb-2">
                                                                <strong>Location / Address:</strong><br>
                                                                <?= htmlspecialchars($company['address']) ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="card-footer bg-light text-muted">
                                                        <i class="fa fa-boxes"></i> Items stored with this company are listed below.
                                                    </div>
                                                </div>

                                                <h5 class="mt-4">Items in Storage</h5>
                                                <table class="table table-striped table-bordered">
                                                    <thead>
                                                        <tr class="text-center">
                                                            <th>#</th>
                                                            <th>Product</th>
                                                            <th>Category</th>
                                                            <th>Opening Stock</th>
                                                            <th>Total Received</th>
                                                            <th>Total Released</th>
                                                            <th>Projected Quantity</th>
                                                            <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($products as $i => $item): 
                                                            $quantity = $item['quantity'] ?? 0;
                                                            $min_level = $item['min_level'] ?? 0;
                                                            $is_active = $item['product_state'] ?? 0;

                                                            // Default row has no background color
                                                            $row_class = '';

                                                            // Status and class for the status <td> only
                                                            $status = '';
                                                            $status_class = '';

                                                            if (!$is_active) {
                                                                $status = 'Deactivated';
                                                                $status_class = 'bg-danger text-white';
                                                            } else {
                                                                if ($quantity == 0) {
                                                                    $status = 'Out of Stock';
                                                                    $row_class = 'bg-danger text-white';
                                                                } elseif ($quantity < $min_level) {
                                                                    $status = 'Below Minuimum Stock Level';
                                                                    $row_class = 'bg-warning';
                                                                } else {
                                                                    $status = 'Active Product';
                                                                    $status_class = 'bg-success text-white';
                                                                }
                                                            }

                                                        ?>
                                                            <tr>
                                                                <td><?= $i + 1 ?></td>
                                                                <td><?= htmlspecialchars($item['product_name']) ?></td>
                                                                <td><?= htmlspecialchars($item['category'] ?? '-') ?></td>
                                                                <td style="text-align: center;"><?= number_format($item['opening_stock'] ?? 0, 2) ?></td>
                                                                <td style="text-align: center;"><?= number_format($item['total_received'] ?? 0, 2) ?></td>
                                                                <td style="text-align: center;"><?= number_format($item['total_released'] ?? 0, 2) ?></td>
                                                                <td style="text-align: center;"><?= number_format($item['quantity'], 2) ?></td>
                                                                <td class="text-center <?= $row_class ?: $status_class ?>">
                                                                    <?= $status ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                        </tbody>

                                                </table>


                                            <?php else: ?>
                                                <div class="alert alert-danger">Company not found.</div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
        </body>
    </html>
