<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD || Delivery Note</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/transfers_model.php';
                        include_once 'model/common_model.php';

                        $order_number = $_GET['order_number'];

                        $transfers_model = new transfers_model();
                        $common_model = new common_model();
                        $noteDetails = $transfers_model->getFinalTransferDetails($order_number);
                        $transfer_items = $transfers_model->getTransferItems($order_number);

                        $companyDetails = $common_model->getCompanyDetails();
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Powertex Stock Transfer</small></h3>
                                </div>

                                <div class="title_right">
                    
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Customer Name -->
                                            <div>
                                                <h2 class="mb-0">Sales Receipt</h2>
                                            </div>
                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0 d-flex align-items-center" style="gap: 8px;">
                                                <?php include 'components/action_buttons.php'; ?>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" onclick="history.back();">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>

                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">
                                                        <div id="print-area">

                                                            <?php if ($noteDetails['transfer_state'] == 3): ?>
                                                                <div style=" position: absolute; top: 220px; left: 300px; right: 0; text-align: left; z-index: 1000; pointer-events: none; ">
                                                                    <span style=" display: inline-block; transform: rotate(-30deg); font-size: 50px; color: rgba(220, 53, 69, 0.3); font-weight: bold; border: 4px dashed rgba(220, 53, 69, 0.4); padding: 10px 40px; background-color: rgba(255, 255, 255, 0.2); ">CANCELLED TRANSER</span>
                                                                </div>


                                                                <?php
                                                                    elseif($noteDetails['transfer_state'] == 0):
                                                                ?>
                                                                <div style=" position: absolute; top: 220px; left: 300px; right: 0; text-align: left; z-index: 1000; pointer-events: none; ">
                                                                    <span style=" display: inline-block; transform: rotate(-30deg); font-size: 50px; color: rgba(220, 53, 69, 0.3); font-weight: bold; border: 4px dashed rgba(220, 53, 69, 0.4); padding: 10px 40px; background-color: rgba(255, 255, 255, 0.2); ">DECLINED  TRANSER</span>
                                                                </div>

                                                            <?php endif; ?>

                                                            <div class="x_panel" style="font-family: Arial, sans-serif; font-size: 14px; max-width: 1200px; margin: auto;">
                                                                <!-- Header Section -->
                                                                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px;">
                                                                    <div>
                                                                        <p style="margin: 0;"><strong>TPIN No.</strong> 20205854</p>
                                                                    </div>
                                                                    <div style="text-align: center;">
                                                                        <img src="images/logo.png" alt="Logo" style="height: 60px;"><br>
                                                                    </div>
                                                                    <div style="text-align: right;">
                                                                        <p style="margin: 0;"><strong>TRANSFER NOTE No.</strong> <?= $noteDetails['transfer_id'] ?></p>
                                                                        <p style="margin: 0;"><strong>SOLAR DIVISION</strong></p>
                                                                        <p style="margin: 0;"><strong>Date:</strong> <?= date('d F Y', strtotime($noteDetails['transfer_date'])) ?></p>
                                                                    </div>
                                                                </div>

                                                                <?php
                                                                    $state = $noteDetails['transfer_state'];
                                                                    $status_label = '';
                                                                    $status_color = '';

                                                                    switch ($state) {
                                                                        case 0:
                                                                            $status_label = 'DECLINED';
                                                                            $status_color = 'danger'; // red
                                                                            break;
                                                                        case 1:
                                                                            $status_label = 'PENDING';
                                                                            $status_color = 'warning'; // yellow
                                                                            break;
                                                                        case 2:
                                                                            $status_label = 'ACCEPTED';
                                                                            $status_color = 'success'; // green
                                                                            break;
                                                                        case 3:
                                                                            $status_label = 'CANCELLED';
                                                                            $status_color = 'secondary'; // grey
                                                                            break;
                                                                    }
                                                                ?>

                                                                <?php
                                                                $status_colors = [
                                                                    'success'   => '#28a745',
                                                                    'warning'   => '#ffc107',
                                                                    'danger'    => '#dc3545',
                                                                    'secondary' => '#6c757d'
                                                                ];

                                                                $bg_color = $status_colors[$status_color] ?? '#6c757d'; // default grey
                                                                ?>
                                                                <div style="text-align: right; margin-bottom: 10px;">
                                                                    <span style="
                                                                        display: inline-block;
                                                                        padding: 6px 12px;
                                                                        font-weight: bold;
                                                                        font-size: 14px;
                                                                        color: white;
                                                                        background-color: <?= $bg_color ?>;
                                                                        border-radius: 4px;
                                                                    ">
                                                                        DELIVERY NOTE STATUS: <?= $status_label ?>
                                                                    </span>
                                                                </div>



                                                                <hr style="margin: 8px 0;">

                                                                <!-- Office Info -->
                                                                <?php
                                                                include_once 'general_header.php';
                                                                ?>
                                                                <p><strong><?= strtoupper($noteDetails['destination_name']) ?></strong></p>
                                                                <hr style="margin: 10px 0;">
                                                                <p style="text-align: right;"><u><strong><?= date('d F Y',strtotime(strtoupper($noteDetails['transfer_date']))) ?></strong></u> </p>
                                                                <p style="text-align: left;"><strong>Please receive these goods in good order and condition: -</strong></p>
                                                                <table class="table table-bordered">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>QTY</th>
                                                                            <th>DESCRIPTION</th>
                                                                            <th>CATEGORY</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php
                                                                            $total_quantity = 0;

                                                                            // Loop through the transfer items to calculate the total quantity
                                                                            foreach ($transfer_items as $item): 
                                                                                if ($item['transfer_state'] == 2) {
                                                                                    $total_quantity += $item['qty_accepted'];
                                                                                } else {
                                                                                    $total_quantity += $item['qty_initiated'];
                                                                                }
                                                                            
                                                                        ?>

                                                                            <tr>
                                                                                <td>
                                                                                    <?php
                                                                                        if ($item['transfer_state'] == 2) {
                                                                                            echo number_format($item['qty_initiated'], 2);
                                                                                        } else {
                                                                                            echo number_format($item['qty_initiated'], 2);
                                                                                        }
                                                                                    ?>
                                                                                </td>
                                                                                <td><?= htmlspecialchars($item['product_name']) ?></td>
                                                                                <td><?= htmlspecialchars($item['category_name']) ?></td>
                                                                            </tr>
                                                                        <?php endforeach; ?>
                                                                    </tbody>
                                                                </table>

                                                                <!-- Display the total quantity transferred -->
                                                                <div style="text-align: right; margin-top: 20px;">
                                                                    <strong>Total Quantity Transferred:</strong> <?= number_format($total_quantity, 2) ?>
                                                                </div>

                                                                <?php
                                                                    $state = $noteDetails['transfer_state'];
                                                                ?>

                                                                <hr>

                                                                <?php if ($state == 1): // Pending ?>
                                                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                                                                        <div><strong>Initiated By:</strong> <?= htmlspecialchars($noteDetails['initiated_by_name']) ?></div>
                                                                       <div>
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($companyDetails['directors_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($companyDetails['directors_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                __________________________
                                                                            <?php endif; ?>
                                                                        </div>

                                                                        <div><strong>Transfer Date:</strong> <?= date('d F Y', strtotime($noteDetails['transfer_date'])) ?></div>
                                                                    </div>

                                                                <?php elseif ($state == 2): // Accepted ?>
                                                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; align-items: center; margin-bottom: 10px;">
                                                                        <div style="text-align: left;">
                                                                            <strong>Initiated By:</strong> <?= htmlspecialchars($noteDetails['initiated_by_name']) ?>
                                                                        </div>
                                                                        <div style="text-align: center;">
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($companyDetails['directors_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($companyDetails['directors_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div style="text-align: right;">
                                                                            <strong>Transfer Date:</strong> <?= date('d F Y', strtotime($noteDetails['transfer_date'])) ?>
                                                                        </div>
                                                                    </div>



                                                                    
                                                                   

                                                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; align-items: center; margin-bottom: 10px;">
                                                                        <div style="text-align: left;">
                                                                            <strong>Delivered By:</strong> ____________________
                                                                        </div>
                                                                        <div style="text-align: center;">
                                                                            <strong>Sign:</strong> ____________________
                                                                        </div>
                                                                        <div style="text-align: right;">
                                                                            <strong>Date Delivered:</strong> __________
                                                                        </div>
                                                                    </div>


                                                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; align-items: center; margin-bottom: 10px;">
                                                                        <div style="text-align: left;">
                                                                            <strong>Received and Accepted By:</strong> <?= htmlspecialchars($noteDetails['accepted_by_name']) ?>
                                                                        </div>
                                                                        <div style="text-align: center;">
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($noteDetails['accepted_by_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($noteDetails['accepted_by_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div style="text-align: right;">
                                                                            <strong>Date Received:</strong> <?= date('d F Y', strtotime($noteDetails['datereceived'])) ?>
                                                                        </div>
                                                                    </div>


                                                                <?php elseif ($state == 0): // Declined ?>
                                                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                                                                        <div><strong>Initiated By:</strong> <?= htmlspecialchars($noteDetails['initiated_by_name']) ?></div>
                                                                       <div>
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($companyDetails['directors_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($companyDetails['directors_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>

                                                                        <div><strong>Transfer Date:</strong> <?= date('d F Y', strtotime($noteDetails['transfer_date'])) ?></div>
                                                                    </div>

                                                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                                                                        <div><strong>Declined By:</strong> <?= htmlspecialchars($noteDetails['declined_by_name']) ?></div>
                                                                        <div>
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($noteDetails['declined_by_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($noteDetails['declined_by_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div><strong>Date Declined:</strong> <?= date('d F Y', strtotime($noteDetails['date_declined'])) ?></div>
                                                                    </div>  

                                                                <?php elseif ($state == 3): // Cancelled ?>
                                                                    <!-- Initiated Row -->
                                                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; align-items: center; margin-bottom: 10px;">
                                                                        <div style="text-align: left;">
                                                                            <strong>Initiated By:</strong> <?= htmlspecialchars($noteDetails['initiated_by_name']) ?>
                                                                        </div>
                                                                        <div style="text-align: center;">
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($companyDetails['directors_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($companyDetails['directors_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div style="text-align: right;">
                                                                            <strong>Transfer Date:</strong> <?= date('d F Y', strtotime($noteDetails['transfer_date'])) ?>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Cancelled By Row -->
                                                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; align-items: center; margin-bottom: 10px;">
                                                                        <div style="text-align: left;">
                                                                            <strong>Cancelled By:</strong> <?= htmlspecialchars($noteDetails['declined_by_name']) ?>
                                                                        </div>
                                                                        <div style="text-align: center;">
                                                                            <strong>Sign:</strong>
                                                                            <?php if (!empty($noteDetails['declined_by_signature'])): ?>
                                                                                <img src="signatures/<?= htmlspecialchars($noteDetails['declined_by_signature']) ?>" alt="Signature" style="height: 30px; vertical-align: middle;">
                                                                            <?php else: ?>
                                                                                ____________________
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div style="text-align: right;">
                                                                            <strong>Date Cancelled:</strong> <?= date('d F Y', strtotime($noteDetails['date_cancelled'])) ?>
                                                                        </div>
                                                                    </div>

                                                                    <p style="text-align: center;color:red"><em><strong>This transfer was cancelled by management.</strong></em></p>
                                                                <?php endif; ?>


                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
        </body>
    </html>
