<?php
	session_start();
	include 'model/users_model.php';
	include_once 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Users</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 20px;
				color: #069;
				text-transform:uppercase;
			}
			 /* Set font size and width for Select2 */
			.select2 {
				font-size: 18px;   /* Adjust font size */
				height: 40px; 
				}     /* Optional: height */
			.select2 {
				display: block;
				width: 100%;
				height: calc(1.5em + .75rem + 2px);
				font-size: 1rem;
				font-weight: 400;
				background-color: #fff;
				background-clip: padding-box;
				border-radius: .25rem;
				transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;

			}

			.select2{
				width: 320px !important;  /* Adjust width */
			}
			/* Align selected option text and set font color */
			.select2-selection__rendered {
				text-align: left !important;
				color: #495057 !important;
			}

			/* Align dropdown items text and set font color */
			.select2-results__option {
				text-align: left !important;
				color: #495057 !important;
			}
		</style>
	</head>
	<body>
		<?php
			$users_model = new users_model();
			$common_model =new common_model();

            $username = $_GET['username'];
            $userDetails = $users_model->getUserDetails($username);
			$locations = $common_model->getAllLocations();
            $roles = [
                'Cashier',
				'Chief Administrator',
                'Supervisor',
				'SysAdmin'
            ];

            $roleLabels = [
                'Cashier'   => 'Cashier',
				'Chief Administrator' => 'Chief Administrator',
				'Supervisor' => 'Supervisor',
                'SysAdmin'  => 'System Administrator'
                
            ];

		?>
		
		<form action="controllers/users_controller.php" method="post">
			<center>
				<h2 class="page_titles">UPDATE ROLE - <?php echo $userDetails['fullname'] ?> <i class="fa fa-mug-hot"></i></h2>
				<hr>

				<span style="float:left;margin-left:20px;font-size:16px;">Fullname</span>
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="employee_name" name="employee_name" value="<?php echo $userDetails['fullname']?>" class="form-control" readonly>
                <input type="hidden" name="action" value="update_user" readonly>
                <input type="hidden" name="employee_code" value="<?= $userDetails['employee_code']?>" readonly>
                <br>
					
				<span style="float:left;margin-left:20px;font-size:16px;">System Username</span>
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="username" name="username" value="<?php echo $userDetails['username']?>" class="form-control" readonly>
                <br>

				<span style="float:left;margin-left:20px;font-size:16px;">Current Role</span>
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="current_role" name="current_role" value="<?php echo $userDetails['role']?>" class="form-control" readonly>
                <br>

				<?php 
					if ($userDetails['role'] == 'Supervisor' || $userDetails['role'] == 'Cashier') {
				?>
					<div id="assigned_location">
						<span style="float:left;margin-left:20px;font-size:16px;">Assigned Location</span>
						<input type='text' style='width: 320px; height:40px;' autocomplete='off' id='assigned_location' name='assigned_location' value="<?php echo $userDetails['assigned_location']?>"  class='form-control' readonly>
						<br>
					</div>
				<?php
					}
				?>
				<span style="float:left;margin-left:20px;font-size:16px;">Select New Role</span>
                <select name="new_role" id="new_role" class="form-control" style="width: 320px; height: 40px;">
                    <option value="<?= htmlspecialchars($userDetails['role']) ?>" selected>
                        <?= htmlspecialchars($roleLabels[$userDetails['role']] ?? $userDetails['role']) ?>
                    </option>

                    <?php foreach ($roles as $role): ?>
                        <?php if ($role !== $userDetails['role']): ?>
                            <option value="<?= htmlspecialchars($role) ?>">
                                <?= htmlspecialchars($roleLabels[$role]) ?>
                            </option>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </select>
				<br>

				<!-- Location dropdown (hidden by default) -->
				<div id="new_role_location_container" style="display:none;">
					<span style="float:left;margin-left:20px;font-size:16px;">Select New Role Location</span>
					<select name="new_role_location" id="new_role_location" class="form-control" style="width: 320px; height:40px">
						<option value="" selected disabled>Select Location</option>
						<?php foreach ($locations as $loc): ?>
							<option value="<?= htmlspecialchars($loc['loc_id']) ?>"><?= htmlspecialchars($loc['location_name']) ?></option>
						<?php endforeach; ?>
					</select>
					<br>
				</div>
				
				<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">UPDATE ROLE <i class="fa fa-save"></i></button>
			</center>
		</form>
		<script>
			function attachRoleChangeHandler() {
				const roleSelect = document.getElementById("new_role");
				const locationContainer = document.getElementById("new_role_location_container");

				if (!roleSelect || !locationContainer) return;

				roleSelect.addEventListener("change", function () {
					const selectedRole = this.value;
					if (selectedRole === "Cashier" || selectedRole === "Supervisor") {
						locationContainer.style.display = "block";
					} else {
						locationContainer.style.display = "none";
					}
				});
			}

			// Call it immediately after defining
			attachRoleChangeHandler();
		</script>

	</body>
</html>