<?php
session_start();    

    require_once 'model/users_model.php';

    $users_model = new users_model();


    if (!isset($_GET['username']) || empty($_GET['username'])) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Failed',
            'message' => 'Invalid request: missing username.'
        ];
        header('Location: system_users.php');
        exit;
    }

    $username = $_GET['username'];
    $userstate = $_GET['userstate'];

    $logged_user = $_SESSION['sess_username'];
    if($logged_user == $username){
        $_SESSION['notification'] = [
            'type'    => 'error',
            'title'   => 'Update Failed',
            'message' => "Cannot disable currently logged in user"
        ];
        header('Location: system_users.php');
        exit;
    }

    $disable_user = $users_model->updateUserState($username, $userstate);

    if ($disable_user) {
        $_SESSION['notification'] = [
            'type'    => 'success',
            'title'   => 'Success',
            'message' => "User state has been updated successfully"
        ];
        header('Location: system_users.php');
        exit;
    } else {
        $_SESSION['notification'] = [
            'type'    => 'error',
            'title'   => 'Update Failed',
            'message' => "Connection error<br>User state could not be updated<br>Try Again"
        ];
        header('Location: system_users.php');
        exit;
    }

    



