    <?php 
        include('menu_supervisor.php');
        include_once 'model/customers_model.php';
        include_once 'model/sales_model.php';

        $customers_model = new customers_model();
        $sales_model = new sales_model();

        $customers = $sales_model->getCustomersWithActiveInvoices();
        $recent_payments = $sales_model->getRecentPayments(6);
        $stats = $sales_model->getQuickPaymentStats();
    ?>

    <!DOCTYPE html>
        <html lang="en">
            <head>
                <meta charset="utf-8">
                <meta name="viewport" content="width=device-width, initial-scale=1">
                <title>Capture Invoice Payments</title>

                <link rel="icon" type="image/png" href="../finance/images/favicon.png">
                <link href="../includes/plugins/select2/css/select2.min.css" rel="stylesheet" />

                <style>
                    .card-modern {
                        background: #fff;
                        border-radius: 6px;
                        padding: 20px;
                        box-shadow: 0 2px 6px rgba(0,0,0,0.08);
                        margin-bottom: 20px;
                    }
                    .table thead th {
                        background: #3c8dbc;
                        color: white;
                    }
                    .processing {
                        opacity: 0.6;
                        cursor: not-allowed;
                    }
                    .select2-container .select2-selection--single {
                        height: 38px !important;
                        padding: 6px 12px;
                        border: 1px solid #ced4da !important;
                        border-radius: 4px !important;
                        background-color: #fff !important;
                    }

                    .select2-container--default .select2-selection--single .select2-selection__rendered {
                        line-height: 26px !important;
                        color: #495057 !important;
                        font-size: 18px;
                    }

                    .select2-container--default .select2-selection--single .select2-selection__arrow {
                        height: 36px !important;
                        right: 8px;
                    }

                    .select2-container--default.select2-container--focus .select2-selection--single {
                        border-color: #80bdff !important;
                        box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
                    }

                </style>
            </head>

            <body class="hold-transition sidebar-mini layout-fixed">

                <div class="content-wrapper p-4">

                    <!-- 🔹 PAGE TITLE (TOP) -->
                    <h3 class="text-primary mb-4">
                        <i class="fa fa-money-check-alt"></i> Capture Invoice Payment
                    </h3>

                    <!-- 🔹 QUICK STATS -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="card-modern text-center">
                                <h6>Customers with Balance</h6>
                                <h4 class="text-danger"><?= $stats['customers_with_balance'] ?></h4>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card-modern text-center">
                                <h6>Total Outstanding</h6>
                                <h4 class="text-warning"><?= number_format($stats['total_outstanding'],2) ?></h4>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card-modern text-center">
                                <h6>Payments Today</h6>
                                <h4 class="text-success"><?= number_format($stats['payments_today'],2) ?></h4>
                            </div>
                        </div>
                    </div>

                    <!-- 🔹 PAYMENT FORM -->
                    <div class="card-modern">

                        <div id="beforeCustomerSelect" class="text-center text-muted py-5">
                            <i class="fa fa-user-circle fa-3x mb-3"></i>
                            <h5>Select a customer to begin</h5>
                            <p>Outstanding invoices and payment details will appear here.</p>
                        </div>

                        <form method="POST" id="paymentForm" action="controllers/payments_controller.php">
                            <input type="hidden" name="action" value="process_invoice_payment">
                            <input type="hidden" id="location" name="location" value="<?= $location ?>">

                            <div class="form-group">
                                <label>Select Customer</label>
                                <select name="customer_id" id="customerSelect" class="form-control select2" required>
                                    <option value="">-- Select Customer --</option>
                                    <?php foreach($customers as $c): ?>
                                        <option value="<?= $c['customer_id'] ?>">
                                            <?= htmlspecialchars($c['customer_name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <!-- Invoice Section with Payment Fields -->
                            <div id="invoiceSection" style="display:none;">
                                <h5>Active Invoices</h5>

                                <table class="table table-bordered" id="invoiceTable">
                                    <thead>
                                        <tr>
                                            <th style="width:40px;">Select</th>
                                            <th>Invoice</th>
                                            <th>Date</th>
                                            <th>Total</th>
                                            <th>Paid</th>
                                            <th>Balance</th>
                                            <th style="width:140px;">Amount to Pay</th>
                                        </tr>
                                    </thead>

                                    <tbody></tbody>
                                </table>

                                <div class="form-row align-items-end">
                                    <!-- Total Remaining Balance -->
                                    <div class="form-group col-md-2">
                                        <label for="totalBalance">Total Remaining Balance</label>
                                        <input type="text" id="totalBalance" class="form-control text-right" readonly>
                                    </div>

                                    <!-- Total Paid -->
                                    <div class="form-group col-md-2">
                                        <label for="totalPaid">Total Paid</label>
                                        <input type="text" id="totalPaid" name="amount_paid" class="form-control text-right" readonly>
                                    </div>

                                    <!-- Payment Method -->
                                    <div class="form-group col-md-2">
                                        <label for="paymentMethod">Payment Method</label>
                                        <select id="payment_method" name="payment_method" class="form-control" required>
                                            <option value="">-- Select Method --</option>
                                            <option value="Cash">Cash</option>
                                            <option value="Cheque">Cheque</option>
                                            <option value="Airtel Money">Airtel Money</option>
                                            <option value="Mpamba">Mpamba</option>
                                            <option value="Visa">Visa</option>
                                            <option value="POS Machine">Pos Machine</option>
                                            <option value="Online Transfer">Online Transfer</option>
                                        </select>
                                    </div>

                                    <!-- Transaction ID -->
                                    <div class="form-group col-md-2">
                                        <label id="transactionLabel" for="transactionId">Transaction ID</label>
                                        <input type="text" id="transactionId" name="transactionId" class="form-control" required>
                                        <small id="transactionError" class="text-danger"></small>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <label id="paymentDateLabel" for="payment_date">Payment Date</label>
                                        <input type="date" id="payment_date" max="<?= date('Y-m-d') ?>" class="form-control" name="payment_date" required>
                                    </div>

                                    <!-- Submit Button -->
                                    <div class="form-group col-md-2">
                                        <button type="submit" id="processPaymentBtn" class="btn btn-success btn-block">
                                            <i class="fa fa-check-circle"></i> Capture Payment
                                        </button>
                                    </div>
                                </div>



                                
                            </div>

                        </form>
                    </div>

                    <!-- 🔹 RECENT PAYMENTS -->
                    <div class="card-modern">
                        <h5 class="text-secondary mb-3">
                            <i class="fa fa-history"></i> Recent Payments
                        </h5>

                        <div class="table-responsive">
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Customer</th>
                                        <th>Method</th>
                                        <th>Ref</th>
                                        <th>Type</th>
                                        <th>Receipt</th>
                                        <th class="text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($recent_payments as $p): ?>
                                    <tr>
                                        <td><?= date('d M Y H:i', strtotime($p['payment_date'])) ?></td>
                                        <td><?= htmlspecialchars($p['customer_name']) ?></td>
                                        <td><?= $p['payment_method'] ?></td>
                                        <td><?= $p['transaction_id'] ?></td>
                                        <td><?= $p['payment_type'] ?></td>
                                        <td><?= $p['receipt_number'] ?></td>
                                        <td class="text-right"><?= number_format($p['amount_paid'],2) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>

                <script src="../includes/plugins/jquery/jquery.min.js"></script>
                <script src="../includes/plugins/select2/js/select2.min.js"></script>



                <script>
                // Fetch invoices on customer select
                $("#customerSelect").change(function(){
                    const cid = $(this).val();
                    if(!cid) return;

                    $.post("controllers/sales_controller.php", { action: "fetch_active_invoices", customer_id: cid }, function(res){
                        const data = JSON.parse(res);
                        if(data.length){
                            $("#invoiceSection").show();
                            let totalBal = 0;
                            let rows = "";
                            data.forEach(inv => {
                                rows += `
                                    <tr>
                                        <td class="text-center">
                                            <input type="checkbox" 
                                                class="invoice-check"
                                                data-invoice-id="${inv.invoice_number}">
                                        </td>

                                        <td>${inv.invoice_number}</td>
                                        <td>${inv.invoice_date}</td>
                                        <td>${Number(inv.total).toFixed(2)}</td>
                                        <td>${Number(inv.paid).toFixed(2)}</td>
                                        <td class="balance">${Number(inv.balance).toFixed(2)}</td>

                                        <td>
                                            <input type="number"
                                                step="0.01"
                                                class="form-control form-control-sm invoice-amount"
                                                data-invoice-id="${inv.invoice_number}"
                                                data-balance="${inv.balance}"
                                                disabled>
                                        </td>
                                    </tr>`;


                                totalBal += Number(inv.balance);

                            });
                            $("#invoiceTable tbody").html(rows);
                            $("#totalBalance").val(totalBal.toFixed(2));
                            $("#paymentDetails").show();
                        } else {
                            $("#invoiceSection").hide();
                            $("#paymentDetails").hide();
                        }
                    });
                });

                // Cap amount to invoice balance
                $(document).on('input', '.invoice-amount', function () {

                    const balance = parseFloat($(this).data('balance'));
                    let value = parseFloat($(this).val());

                    if (isNaN(value)) return;

                    if (value > balance) {
                        $(this).val(balance.toFixed(2));
                    }

                    if (value < 0) {
                        $(this).val('');
                    }
                });


                // Enable / disable amount field when invoice is selected
                $(document).on('change', '.invoice-check', function () {

                    const row = $(this).closest('tr');
                    const amountInput = row.find('.invoice-amount');

                    if ($(this).is(':checked')) {

                        amountInput
                            .prop('disabled', false)
                            .prop('required', true)
                            .focus();

                    } else {

                        amountInput
                            .val('')
                            .prop('disabled', true)
                            .prop('required', false);
                    }
                });



                $('.select2').select2();
                
                // STEP 2 — Update behavior when payment method changes
                $("#payment_method").change(function () {
                    const method = $(this).val();

                    // Ensure error is fully cleared
                    $('#transactionError').hide().html("");
                    $('#processPaymentBtn').prop('disabled', false);

                    // Always show field
                    $("#transactionGroup").show();

                    if (method === "Cash") {

                        // Generate ID
                        const cashId = generateCashTransactionId();

                        // Insert and lock
                        $("#transactionId").val(cashId).prop("readonly", true);

                        $("#transactionLabel").text("Transaction ID");

                        // Remove the required attribute
                        $("#transactionId").prop("required", false);

                        // IMPORTANT: Force trigger validation so error clears
                        $("#transactionId").trigger("keyup");

                    } else {

                        // Clear field and unlock
                        $("#transactionId").val("").prop("readonly", false);

                        // Set the correct label for non-cash methods
                        $("#transactionLabel").text(
                            method === "Cheque" ? "Cheque Number" : "Transaction ID"
                        );

                        // Add the required attribute
                        $("#transactionId").prop("required", true);

                        // Force clear residual errors
                        $('#transactionError').hide().html("");
                        $('#processPaymentBtn').prop('disabled', false);
                    }
                });

                
                function updateTotalPaid() {
                    let total = 0;
                    $('.invoice-amount').each(function() {
                        let val = parseFloat($(this).val());
                        if(!isNaN(val)) total += val;
                    });
                    $('#totalPaid').val(total.toFixed(2));
                }

                $(document).on('input', '.invoice-amount', updateTotalPaid);



                function generateCashTransactionId() {
                    const now = new Date();

                    const datePart =
                        now.getFullYear().toString() +
                        String(now.getMonth() + 1).padStart(2, '0') +
                        String(now.getDate()).padStart(2, '0');

                    const randomPart = Math.random().toString(36).substring(2, 6).toUpperCase();

                    return `CASH-${datePart}-${randomPart}`;
                }

                $("#customerSelect").change(function(){
                    $("#beforeCustomerSelect").hide();
                });

                

                $('#transactionId').on('keyup change', function() {
                    let value = $(this).val();
                    let action = 'check_transid';

                    if (value.length === 0) {
                        $('#transactionError').hide();
                        $('#processPaymentBtn').prop('disabled', false);
                        return;
                    }

                    $.ajax({
                        url: 'controllers/sales_controller.php',
                        type: 'POST',
                        data: { transaction_id: value, action: action },
                        success: function(response) {

                            let res = JSON.parse(response);

                            if (res.exists) {

                                // Show error
                                $('#transactionError')
                                    .html("Transaction ID already exists")
                                    .css('color', 'red')
                                    .show();

                                // Disable submit button
                                $('#processPaymentBtn').prop('disabled', true);

                            } else {

                                // Hide error
                                $('#transactionError').hide();

                                // Enable submit button
                                $('#processPaymentBtn').prop('disabled', false);
                            }
                        }
                    });
                });

                $("#processPaymentBtn").on("click", function (e) {
                                e.preventDefault();

                                const customerId    = $("#customerSelect").val();
                                const paymentMethod = $("#payment_method").val();
                                const paymentDate   = $("#payment_date").val();
                                const transactionId = $("#transactionId").val().trim();
                                const enteredAmount = parseFloat($("#totalPaid").val()) || 0;
                                const debug         = 0; // toggle debug mode

                                // ---- INVOICE VALIDATION ----
                                let selectedInvoices = [];
                                let totalSelected = 0;
                                let invoiceError = false;

                                $(".invoice-check:checked").each(function () {
                                    const invoiceId   = $(this).data("invoice-id");
                                    const amountInput = $('.invoice-amount[data-invoice-id="' + invoiceId + '"]');
                                    const amount      = parseFloat(amountInput.val()) || 0;
                                    const balance     = parseFloat(amountInput.data("balance"));

                                    if (amount <= 0) {
                                        Swal.fire({
                                            icon: 'warning',
                                            title: 'Invalid Invoice Amount',
                                            text: 'Amount required for invoice ' + invoiceId
                                        });
                                        invoiceError = true;
                                        return false;
                                    }

                                    if (amount > balance) {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Amount Exceeded',
                                            text: 'Amount exceeds balance for invoice ' + invoiceId
                                        });
                                        invoiceError = true;
                                        return false;
                                    }

                                    selectedInvoices.push({
                                        invoice_number: invoiceId,
                                        amount: amount
                                    });

                                    totalSelected += amount;
                                });

                                if (invoiceError) return;

                                if (selectedInvoices.length === 0) {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'No Invoice Selected',
                                        text: 'Please select at least one invoice'
                                    });
                                    return;
                                }

                                // ---- BASIC FORM VALIDATION ----
                                if (!customerId) {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'Missing Customer',
                                        text: 'Please select a customer'
                                    });
                                    return;
                                }

                                if (!paymentMethod) {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'Missing Payment Method',
                                        text: 'Please select a payment method'
                                    });
                                    return;
                                }

                                if (paymentMethod !== "Cash" && transactionId === "") {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'Missing Transaction ID',
                                        text: 'Transaction ID is required for ' + paymentMethod
                                    });
                                    $("#transactionId").focus();
                                    return;
                                }

                                if (!paymentDate) {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'Missing Payment Date',
                                        text: 'Please select a payment date'
                                    });
                                    return;
                                }

                                if (enteredAmount <= 0) {
                                    Swal.fire({
                                        icon: 'warning',
                                        title: 'Invalid Amount',
                                        text: 'Payment amount must be greater than zero'
                                    });
                                    return;
                                }

                                if (totalSelected !== enteredAmount) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Amount Mismatch',
                                        text: 'Selected invoice totals must equal payment amount'
                                    });
                                    return;
                                }

                                $.post("controllers/payments_controller.php", {
                                    action: "process_invoice_payment",
                                    debug: debug, // 1 for preview, 0 for real submission
                                    customer_id: customerId,
                                    payment_method: paymentMethod,
                                    transactionId: transactionId,
                                    payment_date: paymentDate,
                                    amount_paid: enteredAmount,
                                    location: $("#location").val(),
                                    selected_invoices: selectedInvoices
                                }, function (res) {

                                    let response;
                                    try {
                                        response = typeof res === "string" ? JSON.parse(res) : res;
                                    } catch (e) {
                                        Swal.fire({ icon: 'error', title: 'System Error', text: 'Invalid server response' });
                                        return;
                                    }

                                    if(response.status === 'error') {
                                        Swal.fire({ icon: 'error', title: 'Submission Failed', text: response.message });
                                        return;
                                    }

                                    if(response.status === 'preview') {
                                        // --- debug mode: show preview
                                        const preview = response.data;

                                        let rows = '';
                                        preview.invoice_payments.forEach(inv => {
                                            rows += `
                                                <tr>
                                                    <td>${inv.invoice_number}</td>
                                                    <td class="text-right">${Number(inv.amount_paid).toFixed(2)}</td>
                                                    <td class="text-right">${Number(inv.balance).toFixed(2)}</td>
                                                </tr>
                                            `;
                                        });

                                        const html = `
                                            <div style="text-align:left">
                                                <p><strong>Receipt #:</strong> ${preview.payment.receipt_number}</p>
                                                <p><strong>Payment Method:</strong> ${preview.payment.payment_method}</p>
                                                ${paymentMethod !== 'Cash' ? `<p><strong>Transaction ID:</strong> ${preview.payment.transaction_id}</p>` : ''}
                                                <p><strong>Payment Date:</strong> ${preview.payment.payment_date}</p>
                                                <p><strong>Customer:</strong> ${$("#customerSelect option:selected").text()}</p>
                                                <hr>
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>Invoice</th>
                                                            <th class="text-right">Paid</th>
                                                            <th class="text-right">Remaining</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        ${rows}
                                                    </tbody>
                                                </table>
                                                <hr>
                                                <p><strong>Total Paid:</strong> ${Number(preview.payment.amount_paid).toFixed(2)}</p>
                                                <p><strong>Customer Balance After Payment:</strong> ${Number(preview.payment.balance).toFixed(2)}</p>
                                                <hr>
                                                <pre style="font-size:12px; white-space:pre-wrap; background:#f9f9f9; padding:10px; border-radius:5px;">
                                JSON Preview:
                                ${JSON.stringify(preview, null, 4)}
                                                </pre>
                                            </div>
                                        `;

                                        Swal.fire({
                                            title: 'Payment Preview (Debug Mode)',
                                            html: html,
                                            width: 750,
                                            icon: 'info',
                                            showCancelButton: true,
                                            confirmButtonText: 'Process Payment',
                                            cancelButtonText: 'Cancel',
                                            reverseButtons: true,
                                            customClass: { popup: 'swal-wide' }
                                        }).then((result) => {
                                            if(result.isConfirmed) {
                                                // You can submit final payment here if desired
                                                console.log('Confirmed – ready for final submission');
                                            }
                                        });

                                    } else if(response.status === 'success') {
                                        // --- normal mode: redirect to receipt page
                                        if(response.payment_id){
                                            Swal.fire({
                                                title: 'Processing Payment...',
                                                html: '<div class="spinner-border text-primary" role="status"><span class="sr-only">Please wait...</span></div>',
                                                allowOutsideClick: false,
                                                showConfirmButton: false,
                                                didOpen: () => {
                                                    Swal.showLoading();
                                                }
                                            });

                                            // Slight delay to ensure modal renders before redirect
                                            setTimeout(() => {
                                                window.location.href = 'invoice_payment_receipt.php?id=' + response.payment_id;
                                            }, 1600);
                                        } else {
                                            Swal.fire({ icon:'error', title:'Submission Failed', text:'Payment ID missing' });
                                        }

                                    }
                                });


                            });





                </script>
            </body>
        </html>
