<?php include('menu_supervisor.php'); ?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>POS</title>
            <link rel="apple-touch-icon" sizes="76x76" href="images/icons/favicon.ico">
            <link rel="icon" type="image/png" href="images/icons/favicon.ico">
            <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

            <style>
                #error {
                    color: red;
                    font-size: 0.9em;
                }
                #pinerror {
                    color: red;
                    font-size: 0.9em;
                }
            </style>
        </head>
        <body class="hold-transition sidebar-mini layout-fixed">
            
            <div class="content-wrapper">
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card card-info">
                                    <div class="card-header">
                                        <h3 class="card-title">Change Password</h3>
                                    </div>
                                    <form action="controllers/users_controller.php" method="post">
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label for="newPassword">Username</label>
                                                <input type="text" class="form-control" id="username" name="username" value="<?php echo $_GET['username']?>" readonly>
                                                <input type="hidden" name="action" value="change_password" readonly> 
                                            </div>

                                            <div class="form-group">
                                                    <label for="currentPassword">Current Password</label>
                                                    <input type="password" class="form-control" id="currentPassword" name="current_password" required>
                                                </div>

                                            <div class="form-group">
                                                <label for="newPassword">New Password</label>
                                                <input type="password" minlength="6" class="form-control" id="newPassword" name="new_password" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="confirmPassword">Confirm New Password</label>
                                                <input type="password" class="form-control" id="confirmPassword" name="confirm_password" required>
                                            </div>
                                            <div id="error"></div>
                                        </div>
                                        <div class="card-footer">
                                            <button type="submit" id="submitButton" class="btn btn-info">Change Password</button>
                                        </div>
                                    </form>
                                </div>
                            </div>


                            
                        </div>
                    </div>
                </section>
            </div>

            <script src="plugins/jquery/jquery.min.js"></script>
            <script src="plugins/jquery-ui/jquery-ui.min.js"></script>
            <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="dist/js/adminlte.js"></script>
            <script src="js/script.js"></script>

            <script>
                $(document).ready(function() {
                    $('#currentPassword').on('input', function() {
                        var enteredPassword = $(this).val();

                        $.ajax({
                            type: 'POST',
                            url: 'verify_current_password.php', // Ensure this points to the correct PHP file
                            data: { current_password: enteredPassword },
                            dataType: 'json', // Ensure the response is expected as JSON
                            success: function(response) {
                                // Log the response to the console
                                
                                if (response.valid) {
                                    $('#error').hide();
                                    $('#submitButton').prop('disabled', false);
                                } else {
                                    $('#error').text(response.message).show();
                                    $('#submitButton').prop('disabled', true);
                                }

                                // Additional logging to ensure correctness
                                
                            },
                            error: function(xhr, status, error) {
                                console.log('AJAX Error:', status, error); // Log any AJAX errors to the console
                                $('#error').text('An error occurred. Please try again.').show();
                                $('#submitButton').prop('disabled', true);
                            }
                        });
                    });
                });
            </script>
        </body>
    </html>
