<?php 
include('menu_supervisor.php');
include_once 'model/quotations_model.php';
include_once 'model/common_model.php';

$quotations_model = new quotations_model();
$common_model = new common_model();

$company_details = $common_model->getCompanyDetails();
$quotation_number = $_GET['quote_number'];

$quotation = $quotations_model->getQuotationData($quotation_number);
$items = $quotations_model->getquoteItems($quotation_number);

$state = $quotation['quotation_state'];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Powertex || Customer Quotation</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">

    <style>
        .delivery-note { font-size: 14px; font-family: "Times New Roman", serif; }
        .delivery-note p { font-size: 16px; }
        .delivery-note h6 { font-size: 14px; }

        .office-title {
            font-size: 20px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 2px;
        }

        .office-text { font-size: 14px; line-height: 1.15; }
        .office-block { padding: 0 5px; }

        .dn-title { font-size: 22px; font-weight: bold; }

        .delivery-note th,
        .delivery-note td { font-size: 16px; padding: 5px !important; }

        .table td, .table th { border-bottom: 1px solid #000; }

        .delivery-logo { max-height: 70px; margin: 5px auto; display: block; }

        .watermark {
            position: absolute;
            top: 50%;
            left: 55%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 100px;
            font-weight: bold;
            color: inherit;
            opacity: 0.55;
            white-space: nowrap;
            pointer-events: none;
            z-index: 0;
        }

        @media print {

    body {
        background: #fff !important;
        margin: 0 !important;
        padding: 0 !important;
        font-size: 12pt;
    }

    body * {
        visibility: hidden;
    }

    #printableArea, #printableArea * {
        visibility: visible;
    }

    #printableArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        padding: 0;
        margin: 0;
    }

    /* Remove AdminLTE / Bootstrap visual noise */
    .card,
    .card-body,
    .content-wrapper,
    .container-fluid {
        box-shadow: none !important;
        border: none !important;
        padding: 0 !important;
        margin: 0 !important;
        background: #fff !important;
    }

    /* Table print clarity */
    table {
        width: 100% !important;
        border-collapse: collapse !important;
    }

    th, td {
        border: 1px solid #000 !important;
        padding: 6px !important;
        font-size: 11pt !important;
    }

    /* Force rows not to split across pages */
    tr {
        page-break-inside: avoid !important;
    }

    /* Hide all buttons & modals */
    button,
    .modal,
    .btn,
    .card-header {
        display: none !important;
    }

    /* Watermark positioning fix */
    .watermark {
        position: fixed !important;
        top: 45% !important;
        left: 50% !important;
        transform: translate(-50%, -50%) rotate(-30deg) !important;
        font-size: 90px !important;
        opacity: 0.18 !important;
        z-index: 999 !important;
    }
}

    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
<section class="content">
<div class="container-fluid">

<div class="mb-4">
    <div class="card shadow-sm">
        <div class="card-body d-flex align-items-center">

            <!-- LEFT: TITLE ONLY -->
            <h4 class="mb-0" style="font-weight:bold;">
                Customer Quote #<?= htmlspecialchars($quotation_number) ?>
            </h4>

            <!-- RIGHT: ALL ACTION BUTTONS INCLUDING BACK -->
            <div class="d-flex align-items-center ml-auto">  <!-- ✨ THIS IS THE FIX -->

                <?php
                    if($quotation['quotation_state'] == 1 || $quotation['quotation_state'] == 0):
                        ?>
                        
                        <button class="btn btn-success mr-2" title="Sent Invoice to WhatsApp" onclick="sendToWhatApp('<?= htmlspecialchars($invoice_number, ENT_QUOTES) ?>')">
                            <i class="fab fa-whatsApp"></i> 
                        </button>

                        <button class="btn btn-danger mr-2" title="Email Invoice to Customer" onclick="emailInvoice('<?= $invoice_number ?>')">
                            <i class="fa fa-envelope"></i>
                        </button>

                <?php 
                        endif;
                ?>

                <!-- PRINT BUTTON -->
                <button class="btn btn-primary mr-2" onclick="window.print()">
                    <i class="fa fa-print"></i>
                </button>

                <!-- BACK BUTTON (NOW ON FAR RIGHT) -->
                <button class="btn btn-info" onclick="history.back()">
                    <i class="fa fa-arrow-left ml-1"></i>
                </button>

            </div>

        </div>
    </div>
</div>




<div id="printableArea">

<?php
// -------------------------------------------------------
// STATUS AND WATERMARK LOGIC
// -------------------------------------------------------
  // FIXED — now defined early

$statusMap = [
    0 => ['label' => 'Declined',  'badge' => 'badge-danger'],
    1 => ['label' => 'Pending',   'badge' => 'badge-warning'],
    2 => ['label' => 'Received',  'badge' => 'badge-success'],
    3 => ['label' => 'Cancelled', 'badge' => 'badge-secondary']
];

$watermarkText = [
    0 => "Pending Customer",
    1 => "Approved"
];

$watermarkColors = [
    0 => 'rgba(255, 0, 0, 0.35)',      // Strong Red
    1 => 'rgba(255, 205, 0, 0.40)',    // Strong Yellow
    2 => 'rgba(0, 230, 118, 0.35)',    // Strong Green
    3 => 'rgba(90, 100, 110, 0.40)'    // Strong Grey
];


$wmText  = $watermarkText[$state] ?? '';
$wmColor = $watermarkColors[$state];
?>

<?php if ($wmText != ''): ?>
    <div class="watermark" style="color: <?= $wmColor ?>;">
        <?= $wmText ?>
    </div>
<?php endif; ?>


<div class="container delivery-note" 
     style="max-width: 960px; background:#fff; padding:25px; border:1px solid #000;">

    <?php 
        $docTitle  = "Customer Quote";
        $docNumber = $quotation_number    ;
        include('print_header.php'); 
    ?>

    <hr>

    <div style="font-family: Arial; font-size: 12pt; margin-bottom: 15px;">

       <div style="display:flex; align-items:center; width:100%;">
            <div style="flex:1; text-align:left;">
                <strong><?= htmlspecialchars($quotation['customer_name']) ?></strong>
            </div>
            <div style="flex:1; text-align:right;">
                <b>This quote is valid until</b> <?= date('d F, Y', strtotime($quotation['expiry_date'])) ?>
            </div>
        </div>



        <hr style="border:1px solid #000; margin:5px 0;">

        <div style="text-align:right;">
            <span style="text-decoration:underline;">
                <strong>Date Quoted:</strong> <?= date('d F Y', strtotime($quotation['quotation_date'])) ?>
            </span>
        </div>

    </div>
    <!-- ITEMS TABLE -->
     

<table class="table table-bordered">
    <thead>
    <tr>
        <th>Description</th>
        <th>Category</th>
        <th style="width:20%">Quantity</th>
        <th style="width:25%">@</th>
        <th style="width:15%">Total</th>
    </tr>
    </thead>

    <tbody>

    <?php 
    

    // ✔ Now print the rows
    foreach ($items as $item): 
    ?>
        <tr>
            <td><?= htmlspecialchars($item['product_name']) ?></td>
            <td><?= htmlspecialchars($item['categoryname']) ?></td>
            <td style="text-align: center;"><?= htmlspecialchars($item['qty']) ?></td>
            <td style="text-align:right;"><?= number_format($item['price'],2) ?></td>
            <td style="text-align:right;"><?= number_format($item['subtotal'],2) ?></td>
        </tr>
    <?php endforeach; ?>

    <?php for ($i = count($items); $i < 6; $i++): ?>
        <tr>
            <td>&nbsp;</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
    <?php endfor; ?>

    <!-- ✔ Totals + Customer Block -->
    <tr>
        <td colspan="3" rowspan="4" style="vertical-align: top;">
            <u><?= htmlspecialchars($quotation['customer_name']) ?>
            <strong>Tel:</strong> <?= htmlspecialchars($quotation['customer_phone']) ?></u>
        </td>

        <td><strong>Subtotal</strong></td>
        <td style="text-align:right;"><?= number_format($quotation['subtotal'], 2) ?></td>
    </tr>

    <tr>
        <td><strong>Plus <?= $quotation['vat_percentage'] *100 ?>% VAT</strong></td>
        <td style="text-align:right;"><?= number_format($quotation['total_tax'], 2) ?></td>
    </tr>

    <tr>
        <td><strong>Grand Total</strong></td>
        <td style="text-align:right; font-weight:bold;"><?= number_format($quotation['total'], 2) ?></td>
    </tr>

    </tbody>
</table>


    

</div>

</div> <!-- /printableArea -->

</div>
</section>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>



</body>
</html>
