<?php
include_once 'menu_supervisor.php';
include_once 'model/payments_model.php';
include_once 'model/common_model.php';

if (!isset($_GET['id'])) {
    header('location:invoice_payments.php');
    exit();
}

$payment_id = $_GET['id'];

$payments_model = new payments_model();
$common_model   = new common_model();

$receipt_data = $payments_model->receiptDetailsInvoice($payment_id);
$company      = $common_model->getCompanyDetails();

if (!$receipt_data || !$company) {
    header('location:invoice_payments.php');
    exit();
}

function convertNumberToWords($number) {
    $formatter = new NumberFormatter("en", NumberFormatter::SPELLOUT);
    return ucwords($formatter->format($number)) . " Kwacha";
}

$amount_in_words = convertNumberToWords($receipt_data['amount_paid']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Invoice Payment Receipt</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="icon" type="image/png" href="../finance/images/favicon.png">


    <style>
        /* Print optimisation */
        @media print {
            .main-header,
            .main-sidebar,
            .content-header,
            .btn {
                display: none !important;
            }
            .content-wrapper {
                margin: 0 !important;
                padding: 0 !important;
            }
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

    <?php include_once 'menu_supervisor.php'; ?>

    <div class="content-wrapper">

        <!-- PAGE HEADER -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row align-items-center mb-2">

                    <!-- LEFT -->
                    <div class="col-sm-4">
                        <h5 class="text-muted mb-0">Invoice Payment Details</h5>
                    </div>

                    <!-- CENTER -->
                    <div class="col-sm-4 text-center">
                        <h5 class="font-weight-bold mb-0">Invoice Payment Receipt</h5>
                    </div>

                    <!-- RIGHT ACTION BUTTONS -->
                    <div class="col-sm-4 text-right">
                        <div class="d-inline-flex align-items-center">

                            <a href="#" class="btn btn-success mr-2" title="Share via WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>

                            <a href="#" class="btn btn-info  mr-2" title="Send via Email">
                                   <i class="fas fa-envelope"></i>
                            </a>

                            <button onclick="window.print()" class="btn btn-primary btn-sm mr-2">
                                <i class="fas fa-print"></i> Print
                            </button>

                            <a href="javascript:history.back()" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>

                        </div>
                    </div>


                </div>
                <hr>
            </div>
        </section>

        <!-- CONTENT -->
        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <!-- LEFT ALIGNED RECEIPT -->
                    <div class="col-md-5">

                        <div class="card" style="border-radius:10px;border:1px solid #e5e5e5;">
                            <div class="card-body p-4" id="print-area" style="position:relative;">

                                <!-- CANCELLED WATERMARK -->
                                <?php if ($receipt_data['payment_state'] == 0): ?>
                                    <div style="
                                        position:absolute;
                                        top:45%;
                                        left:5%;
                                        transform:rotate(-30deg);
                                        font-size:40px;
                                        color:rgba(220,53,69,0.25);
                                        font-weight:bold;
                                        border:4px dashed rgba(220,53,69,0.4);
                                        padding:12px 40px;
                                        pointer-events:none;">
                                        CANCELLED
                                    </div>
                                <?php endif; ?>

                                <!-- RECEIPT NUMBER -->
                                <div class="text-center mb-4">
                                    <h6 class="text-uppercase text-muted mb-1">
                                        Receipt No: <strong><?= $receipt_data['receipt_number']; ?></strong>
                                    </h6>
                                </div>

                                <!-- LOGO -->
                                <?php if (!empty($company['logo'])): ?>
                                    <div class="text-center mb-3">
                                        <img src="../finance/images/<?= $company['logo']; ?>" height="70">
                                    </div>
                                <?php endif; ?>

                                <!-- COMPANY INFO -->
                                <div class="text-center text-muted small mb-4">
                                    <?= nl2br($company['physical_location']); ?><br>
                                    <?= $company['postal_address']; ?><br>
                                    Tel: <?= $company['phone_number']; ?><br>
                                    Email: <?= $company['email']; ?>
                                </div>

                                <!-- DATE -->
                                <div class="text-right mb-3">
                                    <strong>Date:</strong>
                                    <?= date('d F, Y', strtotime($receipt_data['payment_date'])); ?>
                                </div>

                                <!-- BODY -->
                                <div style="font-size:15px;">

                                    <p>
                                        <strong>Received from:</strong><br>
                                        <span class="border-bottom d-block pb-1">
                                            <?= $receipt_data['customer_name']; ?>
                                        </span>
                                    </p>

                                    <p>
                                        <strong>The sum of:</strong><br>
                                        <span class="border-bottom d-block pb-1">
                                            <?= $amount_in_words; ?> only
                                        </span>
                                    </p>

                                    <p class="h5 mt-3">
                                        <strong>Amount:</strong>
                                        K <?= number_format($receipt_data['amount_paid'], 2); ?>
                                    </p>

                                    <p>
                                        <strong>Being in Payment of:</strong><br>
                                        <span class="border-bottom d-block pb-1">
                                            Outstanding Invoice Balances
                                        </span>
                                    </p>

                                    <?php if ($receipt_data['payment_state'] == 1): ?>
                                        <p>
                                            <strong>New Balance:</strong>
                                            K <?= number_format($receipt_data['balance'], 2); ?> <b>as of this payment</b>
                                        </p>
                                    <?php endif; ?>

                                </div>

                                <!-- FOOTER -->
                                <div class="row align-items-end mt-4">
                                    <div class="col-6">
                                        <em class="text-muted">With thanks</em>
                                    </div>
                                    <div class="col-6 text-right">
                                        <?php if (!empty($company['directors_signature'])): ?>
                                            <img src="../finance/signatures/<?= $company['directors_signature']; ?>" height="45">
                                        <?php endif; ?>
                                        <div class="text-muted small">Signature</div>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </section>

    </div>
</div>

<!-- REQUIRED SCRIPTS (Bootstrap 4 stack) -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.min.js"></script>

</body>
</html>
