<?php

include_once 'config.php';

class payments_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function beginTransaction() {
        $this->link->beginTransaction();
    }

        public function commit() {
        $this->link->commit();
    }

    public function rollback() {
        $this->link->rollBack();
    }

    public function insertPayment($data) {
        $sql = "INSERT INTO payments (tx_id, sale_id, location, customer, receipt_number, payment_method, payment_type, transction_id, payment_date, discount, amount_paid, balance, datecaptured, operator, payment_state) VALUES (:tx_id, :sale_id, :location, :customer, :receipt_number, :payment_method, :payment_type, :transction_id, :payment_date, :discount, :amount_paid, :balance, :date_captured, :operator, :payment_state)";
        $stmt = $this->link->prepare($sql);
        $stmt->bindValue(':tx_id', $data['tx_id']);
        $stmt->bindValue(':sale_id', $data['sale_id']);
        $stmt->bindValue(':location', $data['location']);
        $stmt->bindValue(':customer', $data['customer']);
        $stmt->bindValue(':receipt_number', $data['receipt_number']);
        $stmt->bindValue(':payment_method', $data['payment_method']);
        $stmt->bindValue(':payment_type', $data['payment_type']);
        $stmt->bindValue(':transction_id', $data['transaction_id']);
        $stmt->bindValue(':payment_date', $data['payment_date']);
        $stmt->bindValue(':discount', $data['discount']);
        $stmt->bindValue(':amount_paid', $data['amount_paid']);
        $stmt->bindValue(':balance', $data['balance']);
        $stmt->bindValue(':date_captured', $data['date_captured']);
        $stmt->bindValue(':operator', $data['operator']);
        $stmt->bindValue(':payment_state', $data['payment_state']);

        return $stmt->execute() ? $this->link->lastInsertId() : false;
    }

    /* -----------------------------
       Insert Invoice Payment
    ------------------------------ */
    public function insertInvoicePayment($data) {
        $sql = "INSERT INTO invoice_payments (payment_id, invoice_number, customer, receipt_number, amount_paid, balance, date_paid, transaction_date, operator, payment_state ) VALUES (:payment_id, :invoice_number, :customer, :receipt_number, :amount_paid, :balance, :date_paid, :transaction_date, :operator, :payment_state)";
        $stmt = $this->link->prepare($sql);
        $stmt->bindValue(':payment_id', $data['payment_id']);
        $stmt->bindValue(':invoice_number', $data['invoice_number']);
        $stmt->bindValue(':customer', $data['customer']);
        $stmt->bindValue(':receipt_number', $data['receipt_number']);
        $stmt->bindValue(':amount_paid', $data['amount_paid']);
        $stmt->bindValue(':balance',$data['balance']);
        $stmt->bindValue(':date_paid', $data['date_paid']);
        $stmt->bindValue(':transaction_date', $data['transaction_date']);
        $stmt->bindValue(':operator', $data['operator']);
        $stmt->bindValue(':payment_state', $data['payment_state']);

        return $stmt->execute();
    }

    public function getLastReceiptNumber() {
        $sql = "SELECT MAX(receipt_number) AS last_receipt FROM payments";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the last receipt number or null if no records exist
        return $result['last_receipt'] ?? null;
    }

    public function updateInvoiceState($invoice_number, $new_state) {
        $sql = "UPDATE 
                    saved_orders 
                SET 
                    order_state = :new_state 
                WHERE 
                    order_number = :invoice_number";
        $stmt = $this->link->prepare($sql);
        $stmt->bindValue(':new_state', $new_state, PDO::PARAM_INT);
        $stmt->bindValue(':invoice_number', $invoice_number);
        return $stmt->execute();
    }

    public function getInvoiceReceiptData($payment_id){
        $sql = "SELECT
                    c.customer_name,
                    p.amount_paid,
                    p.payment_state,
                    p.receipt_number,
                    p.payment_method,
                    p.transction_id,
                    p.payment_date,
                    p.balance,
                    p.payment_type
                FROM 
                    payments p
                LEFT JOIN
                    customers c ON p.customer = c.customer_id
                WHERE 
                    p.id =:id";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':id', $payment_id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch();
        return $data;
    }

    public function getInvoicePayments() {
        $sql = "SELECT 
                    ip.id,
                    ip.payment_id,
                    ip.invoice_number,
                    c.customer_name,
                    ip.amount_paid,
                    p.payment_method,
                    p.transction_id as transaction_id,
                    ip.balance,
                    ip.date_paid,
                    ip.payment_state
                FROM 
                    invoice_payments ip
                LEFT JOIN 
                    customers c ON ip.customer = c.customer_id
                LEFT JOIN
                    payments p ON ip.payment_id = p.id
                ORDER BY 
                    ip.id DESC"; // Order by ID descending (latest first)

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function receiptDetailsInvoice($id){
        $sql = "SELECT 
                    ip.amount_paid,
                    ip.payment_state,
                    CONCAT(p.receipt_number, ' - ',ip.id) as receipt_number,
                    p.payment_date,
                    c.customer_name,
                    ip.balance
                FROM
                    invoice_payments ip
                LEFT JOIN
                    payments p ON ip.payment_id = p.id
                LEFT JOIN
                    customers c ON ip.customer = c.customer_id
                WHERE
                    ip.id=:id";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch();
        return $data;
    }

    public function getPayments($location, $start_date = null, $end_date = null, $range = null) {
        // Explicit date range takes priority
        if (!empty($start_date) && !empty($end_date)) {
            $dateCondition = "DATE(p.payment_date) >= :start_date AND DATE(p.payment_date) <= :end_date";
        } else {
            // Fallback to existing range logic
            switch ($range) {
                case 'daily':
                    $dateCondition = "DATE(p.payment_date) = CURDATE()";
                    break;

                case 'weekly':
                    $dateCondition = "YEARWEEK(p.payment_date, 1) = YEARWEEK(CURDATE(), 1)";
                    break;

                case 'monthly':
                    $dateCondition = "MONTH(p.payment_date) = MONTH(CURDATE()) 
                                    AND YEAR(p.payment_date) = YEAR(CURDATE())";
                    break;

                case 'yearly':
                    $dateCondition = "YEAR(p.payment_date) = YEAR(CURDATE())";
                    break;

                default:
                    $dateCondition = "1=1"; // no date filter
            }
        }


        $sql = "SELECT 
                    p.id,
                    p.receipt_number as payment_reference,
                    c.customer_name as customer,
                    COALESCE(p.sale_id,GROUP_CONCAT(ip.invoice_number SEPARATOR ' - ')) as invoice_reference,
                    p.payment_method,
                    p.transction_id,
                    p.amount_paid as amount,
                    wh.warehouse_name as location,
                    CASE 
                        WHEN p.payment_state = 1 THEN 'Completed'
                        WHEN p.payment_state = 0 THEN 'Cancelled'
                        WHEN p.payment_state = 3 THEN 'Failed'
                    END as status,
                    CASE 
                        WHEN p.payment_type = 'Cash Sale' THEN 'Cash Sale'
                        WHEN p.payment_type = 'Order Payment' THEN 'Customer Invoice Payment'
                    END as type,
                    p.payment_state,
                    p.payment_type,
                    p.sale_id,
                    TIMESTAMP(DATE(p.payment_date), TIME(p.datecaptured)) AS date

                FROM 
                    payments p
                LEFT JOIN
                    customers c ON p.customer = c.customer_id
                LEFT JOIN
                    warehouses wh ON p.location = wh.warehouse_id
                LEFT JOIN
                    invoice_payments ip 
                    ON ip.payment_id = p.id  AND p.sale_id IS NULL AND p.payment_type = 'Order Payment'
                WHERE 
                    p.location = :location
                    AND p.payment_state = 1
                    AND $dateCondition
                GROUP BY
                    p.id
                ORDER BY 
                    p.datecaptured DESC";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_STR);
        if (!empty($start_date) && !empty($end_date)) {
        $stmt->bindParam(':start_date', $start_date);
        $stmt->bindParam(':end_date', $end_date);
    }
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }




    

}