<?php 
include('menu_supervisor.php');
include_once 'model/stock_model.php';
include_once 'model/warehouse_model.php';
include_once 'model/customers_model.php';
include_once 'model/common_model.php';

$stock_model = new stock_model();
$warehouse_model = new warehouse_model();
$customer_model = new customers_model();
$common_model = new common_model();

$companyDetails = $common_model->getCompanyDetails();

$invoice_number = $_GET['invoice_number'] ?? "N/A";
$products = $stock_model->getproducts($location);
$warehouseDetails = $warehouse_model->getWarehouseDetails($location);
$customers = $customer_model->getCustomers($location, ['Dealer', 'Individual', 'Corporate'], 1);
$vat_value = $companyDetails['vat_percentage'];

$locked_customer_id = isset($_GET['customer_id']) ? (int)$_GET['customer_id'] : 0;

?>
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex || New Invoice</title>

<link rel="icon" type="image/png" href="../finance/images/favicon.png">

<style>
.summary-box h5, .summary-box h3 { margin: 8px 0; }
</style>
<style>
/* Summary font adjustments */
.summary-box, 
.summary-box h5, 
.summary-box h3, 
#subTotal, 
#vatAmount, 
#grandTotal {
    font-family: "Times New Roman", serif !important;
}

/* Sizes + colors */
.summary-box h5 {
    font-size: 18px;
    color: #333;
}

.summary-box h3 {
    font-size: 24px;
    color: #0a7d12; /* green total */
}
 /* Make Select2 match Bootstrap form-control styling */
.select2-container .select2-selection--single {
    height: 38px !important;
    padding: 6px 12px;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    background-color: #fff !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 26px !important;
    color: #495057 !important;
    font-size: 17   px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px;
}

/* Focus style same as Bootstrap */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
    outline: 0;
}

/* Match input height also for multiple select (if you use it later) */
.select2-container .select2-selection--multiple {
    min-height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
</style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="mb-4">
        <h4 class="text-primary"><i class="fa fa-shopping-cart"></i> New Customer Invoice</h4>
    </div>

    <!-- HEADER INFO -->
    <div class="card shadow-sm mb-4">
        <div class="card-body row">

            <div class="col-md-2">
                <label><strong>Warehouse</strong></label>
                <input type="text" class="form-control" value="<?= htmlspecialchars($warehouseDetails['warehouse_name']) ?>" readonly>
                <input type="hidden" id="warehouse_id" name="warehouse_id" value="<?= $location ?>" readonly>
            </div>
            
            <div class="col-md-2">
                <label><strong>Sales Number</strong></label>
                <input type="text" class="form-control" id="invoice_number" name="invoice_number" value="<?= htmlspecialchars($invoice_number) ?>" readonly>
            </div>

            <div class="col-md-2">
                <label><strong>Customer</strong></label>
                <select id="customer_id" class="select2" style="width:100%" required <?= $locked_customer_id ? 'data-locked="1"' : '' ?>>
                    <option value="">-- Select Customer --</option>
                    <?php foreach ($customers as $c): ?>
                        <option value="<?= $c['customer_id'] ?>" data-balance="<?= $c['outstanding_balance']?>">
                            <?= htmlspecialchars($c['customer_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-2">
                <label><strong>Customer Balance</strong></label>
                <input type="text" id="customer_balance" class="form-control" value="0.00" readonly>
            </div>

            <div class="col-md-2">
                <label><strong>Date</strong></label>
                <input type="date" class="form-control" id="invoice_date" max="<?= date('Y-m-d') ?>" name="invoice_date" required>
            </div>

            <div class="col-md-2">
                <label><strong>LPO Number</strong></label>
                <input type="text" class="form-control" id="lpo_number" placeholder="Enter Invoice LPO Number" name="lpo_number" required>
            </div>

        </div>
    </div>


    <!-- PRODUCT ENTRY -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <strong>Add Product</strong>
        </div>

        <div class="card-body">
            <div class="row">

                <!-- Product Dropdown -->
                <div class="col-md-4">
                    <label><strong>Product</strong></label>
                    <select id="product_select" class="form-control select2">
                        <option value="">-- Select Product --</option>
                        <?php foreach ($products as $p): ?>
                            <option 
                                value="<?= $p['product_id'] ?>"
                                data-name="<?= $p['product_name'] ?>"
                                data-price="<?= $p['selling_price'] ?>"
                                data-stock="<?= $p['quantity'] ?>"
                            >
                                <?= $p['product_name'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Stock -->
                <div class="col-md-2">
                    <label><strong>Stock</strong></label>
                    <input type="text" id="current_stock" class="form-control" readonly>
                </div>

                <div class="col-md-2">
                    <label><strong>Price</strong></label>
                    <input type="text" id="selling_price" class="form-control" value="" required>
                </div>

                <!-- Qty -->
                <div class="col-md-2">
                    <label><strong>Qty</strong></label>
                    <input type="number" id="qty" class="form-control" min="1" value="1">
                </div>

                <!-- Add Button -->
                <div class="col-md-2">
                    <label>&nbsp;</label>
                    <button id="addItemBtn" class="btn btn-success btn-block">
                        Add <i class="fa fa-plus"></i>
                    </button>
                </div>

            </div>
        </div>
    </div>


    <!-- ITEMS TABLE + SUMMARY SIDE BY SIDE -->
    <div class="row">

        <!-- LEFT: ITEMS TABLE -->
        <div class="col-md-8">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-dark text-white">
                    <strong>Invoice Items</strong>
                </div>

                <div class="card-body table-responsive">
                    <table class="table table-bordered table-striped" id="invoiceTable">
                        <thead class="thead-dark">
                            <tr>
                                <th>Product</th>
                                <th width="12%">Price</th>
                                <th width="10%">Qty</th>
                                <th width="15%">Total</th>
                                <th width="5%">×</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- RIGHT: SUMMARY -->
        <div class="col-md-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-secondary text-white">
                    <strong>Summary</strong>
                </div>

                <div class="card-body">

                    <div class="form-group">
                        <label><strong>Discount</strong></label>
                        <input type="number" id="discount" class="form-control" value="0" min="0">
                    </div>

                    <div class="form-group mb-3">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="applyVAT" checked>
                            <label class="custom-control-label" for="applyVAT"><strong>Apply VAT</strong></label>
                        </div>
                    </div>


                    <div class="p-3 border rounded bg-light summary-box">

                        <h5>
                            Subtotal 
                            <span class="float-right" id="subTotal">0.00</span>
                        </h5>
                        <h5>
                            Discount 
                            <span class="float-right" id="discountAmount">0.00</span>
                        </h5>


                        <h5>
                            VAT 
                            <span class="float-right" id="vatAmount">0.00</span>
                        </h5>

                        <hr>

                        <h3 class="text-success">
                            Total 
                            <span class="float-right" id="grandTotal">0.00</span>
                        </h3>

                    </div>

                    <button class="btn btn-primary btn-lg btn-block mt-3" id="saveInvoiceBtn">
                        <i class="fa fa-check-circle"></i> Save Invoice
                    </button>

                </div>
            </div>
        </div>

    </div>

</div>
<!-- /MODALS -->

<!-- Pending Delivery Note Modal -->
<div class="modal fade" id="dnModal" tabindex="-1">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title"><i class="fa fa-file-invoice-dollar mr-2"></i>Delivery Note Preview</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">

        <!-- Pending DN Alert -->
        <div id="dnAlert" class="alert alert-warning d-flex align-items-center mb-4" role="alert">
          <i class="fa fa-info-circle fa-2x mr-3"></i>
          <div>
            <strong>Pending Delivery Notes Found</strong><br>
            The selected customer has delivery notes. Do you want to create an Invoice?.
          </div>
        </div>

        <!-- Delivery Note Selector / List -->
        <div id="dnList" class="mb-3"></div>

        <!-- Header Info -->
        <div id="dnHeader" class="mb-3"></div>

        <!-- Items Table -->
        <div class="table-responsive">
          <table class="table table-bordered table-sm">
            <thead class="thead-dark">
              <tr>
                <th>Product</th>
                <th>Category</th>
                <th width="15%">Qty</th>
              </tr>
            </thead>
            <tbody id="dnItemsBody"></tbody>
          </table>
        </div>

      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-dismiss="modal">
          <i class="fa fa-times mr-1"></i>Cancel
        </button>
        <button class="btn btn-success" id="confirmLoadDN">
          <i class="fa fa-check mr-1"></i>Create Invoice
        </button>
      </div>

    </div>
  </div>
</div>



<!--<|recently_viewed_code_snippet|`-->
<!-- Scripts -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script src="../includes/plugins/select2/js/select2.min.js"></script>

<script>

//-----------------Initialize Select2--------------------
$('.select2').select2();
// ---------------- LOCK CUSTOMER IF PASSED VIA URL ----------------
// ---------------- LOCK CUSTOMER IF PASSED VIA URL ----------------
const LOCKED_CUSTOMER_ID = <?= $locked_customer_id ?>;

if (LOCKED_CUSTOMER_ID > 0) {

    // Preselect customer
    $("#customer_id")
        .val(LOCKED_CUSTOMER_ID)
        .trigger("change.select2"); // update Select2 UI

    // 🔹 MANUALLY UPDATE BALANCE
    let selected = $("#customer_id option:selected");
    let balance = parseFloat(selected.data("balance")) || 0;

    $("#customer_balance").val(
        balance.toLocaleString('en-US', { minimumFractionDigits: 2 })
    );

    // Disable Select2 UI
    $("#customer_id").prop("disabled", true);
    $("#customer_id").select2();
}



// ------------------------------------------------------
// VAT RATE FROM DATABASE

// ------------------------------------------------------
const VAT_RATE = <?= $vat_value ?>;


// ------------------------------------------------------
// PRODUCT SELECTION — auto-fill stock & price
// ------------------------------------------------------
// ------------------------------------------------------
// PRODUCT SELECTION — allow user to edit price
// ------------------------------------------------------
$("#product_select").change(function () {
    let p = $("#product_select option:selected");

    // Default price is set, but it can be modified
    let price = parseFloat(p.data("price"));
    $("#selling_price").val(price.toFixed(2)); // Display the default price
    $("#current_stock").val(p.data("stock") ?? ""); // Display stock info
});

// ------------------------------------------------------
// UPDATE CUSTOMER BALANCE ON SELECTION
// ------------------------------------------------------
$("#customer_id").change(function() {
    let selected = $("#customer_id option:selected");
    let balance = parseFloat(selected.data("balance")) || 0;

    // Display formatted with comma separators
    $("#customer_balance").val(balance.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
});



// ------------------------------------------------------
// ADD ITEM TO INVOICE TABLE (with editable price and qty)
// ------------------------------------------------------
$("#addItemBtn").click(function () {

    let productID = $("#product_select").val();
    let productName = $("#product_select option:selected").data("name");
    let price = parseFloat($("#selling_price").val());
    let qty = parseInt($("#qty").val());
    let stock = parseInt($("#current_stock").val());

    if (!productID)
        return Swal.fire("Missing Product", "Please select a product.", "warning");

    if (!qty || qty < 1)
        return Swal.fire("Invalid Quantity", "Enter a valid quantity.", "warning");

    if (qty > stock)
        return Swal.fire("Stock Error", "Quantity exceeds available stock!", "error");

    // ❌ Prevent adding same product twice
    let exists = $("#invoiceTable tbody tr[data-id='" + productID + "']").length > 0;
    if (exists)
        return Swal.fire("Duplicate Item", "This product is already added.", "info");

    // Add row to invoice table with editable price
    let total = price * qty;

    let row = `
        <tr data-id="${productID}" data-stock="${stock}" data-price-inc-vat="${price}">
            <td>${productName}</td>

            <td class="text-right">
                <input type="number" readonly class="form-control form-control-sm price-input" value="${price.toFixed(2)}" min="0" style="width:150px;">
            </td>

            <td class="text-center">
                <input type="number" 
                       class="form-control form-control-sm qty-input" 
                       value="${qty}" 
                       min="1"
                       style="width:80px;">
            </td>

            <td class="text-right item-total">
    <input type="text"
           class="form-control form-control-sm item-total-input"
           value="${total.toFixed(2)}"
           readonly>
</td>


            <td class="text-center">
                <button class="btn btn-danger btn-sm deleteRow">
                    <i class="fa fa-times"></i>
                </button>
            </td>
        </tr>
    `;

    $("#invoiceTable tbody").append(row);

    // 🔹 Apply current VAT display state immediately
    updateRowDisplay($("#invoiceTable tbody tr:last"));

    calculateTotals();


    // Reset inputs
    $("#product_select").val("");
    $("#current_stock").val("");
    $("#selling_price").val("");
    $("#qty").val(1);
});


// ------------------------------------------------------
// EDIT PRICE IN INVOICE TABLE — Recalculate totals
// ------------------------------------------------------
$(document).on("input", ".price-input", function () {

    let row = $(this).closest("tr");
    let newPrice = parseFloat($(this).val());
    let qty = parseInt(row.find(".qty-input").val());
    
    if (isNaN(newPrice) || newPrice < 0) {
        Swal.fire("Invalid Price", "Please enter a valid price.", "warning");
        $(this).val(row.children().eq(1).text()); // Reset to original price if invalid
        return;
    }

    let newTotal = newPrice * qty;
    row.find(".item-total-input").val(newTotal.toFixed(2));



    calculateTotals();
});




// ------------------------------------------------------
// DELETE ROW
// ------------------------------------------------------
$(document).on("click", ".deleteRow", function () {
    $(this).closest("tr").remove();
    calculateTotals();
});


// ------------------------------------------------------
// EDIT QTY INSIDE TABLE — Recalculate totals
// ------------------------------------------------------
// ------------------------------------------------------
// EDIT QTY IN INVOICE TABLE — Recalculate totals
// ------------------------------------------------------
$(document).on("input", ".qty-input", function () {

    let row = $(this).closest("tr");
    let qty = parseInt($(this).val());
    let price = parseFloat(row.find(".price-input").val());
    let stock = parseInt(row.data("stock"));

    if (qty < 1) {
        Swal.fire("Invalid Quantity", "Minimum quantity is 1.", "warning");
        $(this).val(1);
        qty = 1;
    }

    if (qty > stock) {
        Swal.fire("Stock Limit", "Quantity exceeds available stock!", "error");
        $(this).val(stock);
        qty = stock;
    }

    let newTotal = qty * price;
    row.find(".item-total-input").val(newTotal.toFixed(2));


    calculateTotals();
});


$("#applyVAT").change(function () {

    $("#invoiceTable tbody tr").each(function () {
        updateRowDisplay($(this));
    });

    calculateTotals();
});

function updateRowDisplay(row) {

    let priceIncVat = parseFloat(row.data("price-inc-vat"));
    let qty = parseInt(row.find(".qty-input").val()) || 0;
    let applyVAT = $("#applyVAT").is(":checked");

    let displayPrice = priceIncVat;
    let displayTotal = priceIncVat * qty;

    if (applyVAT) {
        displayPrice = priceIncVat / (1 + VAT_RATE);
        displayTotal = displayPrice * qty;
    }

    row.find(".price-input").val(displayPrice.toFixed(2));
    row.find(".item-total-input").val(displayTotal.toFixed(2));
}

// ------------------------------------------------------
// VAT CALCULATION — Subtract VAT from the total (if VAT is applied)
// ------------------------------------------------------

function formatDisplay(value) {
    return Number(value).toLocaleString('en-US', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
}


function calculateTotals() {
    let total = 0;

    $("#invoiceTable tbody tr").each(function () {
        let row = $(this);
        let priceIncVat = parseFloat(row.data("price-inc-vat")) || 0;
        let qty = parseInt(row.find(".qty-input").val()) || 0;

        total += priceIncVat * qty;
    });


    let discount = parseFloat($("#discount").val()) || 0;

    // Check if VAT checkbox is checked
    let applyVAT = $("#applyVAT").is(":checked");

    let vatAmount = 0;

    if (applyVAT) {
        // VAT extracted from VAT-inclusive total:
        // VAT = (Total / (1 + VAT_RATE)) * VAT_RATE
        vatAmount = (total / (1 + VAT_RATE)) * VAT_RATE;
    }

    // Subtotal = Total - VAT (subtract VAT from the total to get the correct subtotal)
    let subtotal = total - vatAmount - discount;

    // Grand Total = Subtotal + VAT - Discount
    let grandTotal = subtotal + vatAmount;

    // Update the fields
   $("#subTotal").text(formatDisplay(subtotal));
    $("#vatAmount").text(formatDisplay(vatAmount));
    $("#grandTotal").text(formatDisplay(grandTotal));
    $("#discountAmount").text(formatDisplay(discount));

}




// Recalculate when discount changes
$("#discount").on("input", calculateTotals);



// Recalculate when discount changes
$("#discount").on("input", calculateTotals);


// ------------------------------------------------------
// SAVE INVOICE VALIDATION
// ------------------------------------------------------
$("#saveInvoiceBtn").click(function () {

    if ($("#invoiceTable tbody tr").length === 0) {
        return Swal.fire("Empty Invoice", "Add at least one product.", "warning");
    }

    if (!$("#customer_id").val()) {
        return Swal.fire("Select Customer", "Please choose a customer.", "warning");
    }

    let invoiceDate = $("#invoice_date").val().trim();
    if (invoiceDate === "") {
        return Swal.fire("Select Date", "Please choose invoice date.", "warning");
    }

    let lpoNumber = $("#lpo_number").val().trim();
    if(lpoNumber === ''){
        return Swal.fire("LPO Number", "Enter LPO Number for this Invoice.", "warning");
    }

    // Gather items
    let items = [];
    $("#invoiceTable tbody tr").each(function () {
        let row = $(this);
        items.push({
            product_code: row.data("id"),
            price: parseFloat(row.data("price-inc-vat")), // ALWAYS VAT-inclusive
            qty: parseInt(row.find(".qty-input").val())
        });

    });

    let customer_id    = $("#customer_id").val();
    let discount       = parseFloat($("#discount").val()) || 0;
    let invoice_number = $("#invoice_number").val();
    let warehouse_id   = $("#warehouse_id").val();

    // Get VAT checkbox state (true if checked, false if unchecked)
    let vat_applicable = $("#applyVAT").is(":checked");

    let debug = 0; // 1 = preview only, 0 = save

    // ----- Confirmation before saving -----
    Swal.fire({
        title: 'Are you sure?',
        text: "Do you want to save this invoice?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, save it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {

            // Proceed with AJAX
            $.ajax({
                url: 'controllers/sales_controller.php',
                method: 'POST',
                data: {
                    action: 'save_invoice',
                    customer_id: customer_id,
                    discount: discount,
                    invoice_date: invoiceDate,
                    lpoNumber:lpoNumber,
                    invoice_number: invoice_number,
                    warehouse_id: warehouse_id,
                    vat_applicable: vat_applicable,  // Send VAT checkbox value
                    items: items,
                    debug: debug
                },
                dataType: 'json',
                success: function (response) {

                    if (response.status === 'preview') {
                        Swal.fire({
                            icon: 'info',
                            title: 'Preview Only',
                            html: `<pre style="text-align:left">${JSON.stringify(response, null, 2)}</pre>`,
                            width: 650
                        });
                        return;
                    }

                    if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Invoice Saved',
                            text: 'Invoice has been saved successfully.'
                        }).then(() => {
                            window.location.href = 'customer_invoice.php?invoice_number=' + response.invoice_id;
                        });

                    } else {
                        Swal.fire("Error", response.message, "error");
                    }
                },
                error: function () {
                    Swal.fire("Error", "Something went wrong while saving invoice.", "error");
                }
            });

        } else {
            Swal.fire("Cancelled", "Invoice was not saved.", "info");
        }
    });

});



</script>
<script>
    // When customer is selected
$("#customer_id").change(function() {
    let customer_id = $(this).val();
    if (!customer_id) return;

    resetDNModal(); 

    // 🔹 AJAX call to check pending delivery notes
    $.ajax({
        url: 'controllers/sales_controller.php',
        method: 'POST',
        data: {
            action: 'check_pending_delivery_notes',
            customer_id: customer_id
        },
        dataType: 'json',
        success: function(response) {
    if (response.status === 'none') {
        // No pending delivery notes, proceed as normal
        return;
    }

    let dnListDiv = $("#dnList");
    dnListDiv.empty();

    if (response.status === 'single') {

        let dn = response.delivery_note;

        $("#dnList").html(`
            <h4 class="text-primary">
                Customer Has Pending Delivery Notes<br>
                ${dn.dn_number} | ${dn.dn_date}
            </h4>
            <input type="hidden" id="selectedDNId" value="${dn.dn_number}">
        `);

        // Load preview (NOT invoice)
        loadDNPreview(dn.dn_number);

        $("#dnModal").modal('show');

    } else if (response.status === 'multiple') {
        let html = `<p>Customer Has Pending Delivery Notes:</p>
                    <select class="form-control" id="dnSelect">
                        <option value="">-- Select Delivery Note --</option>`;
        response.delivery_notes.forEach(function(dn) {
            html += `<option value="${dn.dn_number}" data-number="${dn.dn_number}" data-date="${dn.dn_date}">
                        ${dn.dn_number} | Date: ${dn.dn_date}
                    </option>
`;
        });
        html += `</select>`;
        dnListDiv.html(html);
        $("#dnModal").modal('show');
    }
},
        error: function() {
            console.error("Error checking pending delivery notes.");
        }
    });
});



function loadDNPreview(dn_id) {

    $.ajax({
        url: 'controllers/sales_controller.php',
        method: 'POST',
        data: {
            action: 'get_delivery_note_details',
            dn_id: dn_id
        },
        dataType: 'json',
        success: function(res) {

            if (!res.success) {
                Swal.fire("Error", "Failed to load delivery note.", "error");
                return;
            }

            let dn = res.delivery_note;
            let items = res.items;

            // Header
            $("#dnHeader").html(`
                <div class="border p-2 bg-light">
                    <strong>Delivery Note:</strong> ${dn.dn_number}<br>
                    <strong>Date:</strong> ${dn.dn_date}<br>
                    <strong>Reference:</strong> ${dn.reference ?? ''}
                </div>
            `);

            // Items
            let tbody = $("#dnItemsBody");
            tbody.empty();

            items.forEach(item => {
                tbody.append(`
                    <tr>
                        <td>${item.product_name}</td>
                        <td>${item.categoryname}</td>
                        <td class="text-center">${item.quantity}</td>
                    </tr>
                `);
            });
        }
    });
}

function resetDNModal() {
    $("#dnHeader").html('');
    $("#dnItemsBody").empty();
    $("#dnList").html('');
    $("#selectedDNId").remove();
}

$(document).on('change', '#dnSelect', function () {

    let selectedDN = $(this).val();

    // Clear previous preview first
    $("#dnHeader").html('');
    $("#dnItemsBody").empty();
    $("#selectedDNId").remove();

    if (!selectedDN) return;

    // Store selected DN
    $("#dnList").append(`<input type="hidden" id="selectedDNId" value="${selectedDN}">`);

    // Load preview
    loadDNPreview(selectedDN);
});

$("#confirmLoadDN").click(function() {

    // Determine selected DN
    let dnId = $("#selectedDNId").val() || $("#dnSelect").val();

    if (!dnId) {
        Swal.fire("Select Delivery Note", "Please select a delivery note to create the invoice.", "warning");
        return;
    }

    // Optionally, generate a new invoice number dynamically
    let newInvoiceNumber = "INV" + new Date().toISOString().slice(0,10).replace(/-/g,'') + "-001";

    // Redirect to the new invoice page
    window.location.href = `new_customer_invoice_with_dn.php?dn_number=${encodeURIComponent(dnId)}`;
});






</script>


</body>
</html>
