<?php 
include('menu_supervisor.php');
include_once 'model/common_model.php';

$common_model = new Common_model();

// Fetch all incomplete transactions for this user
$incompleteTransactions = $common_model->getIncompleteTransactions($employee_code);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Incomplete Transactions</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <style>
        .table-responsive { max-height: 600px; overflow-y: auto; }
        .truncate { max-width: 150px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="row mb-3">
        <div class="col-12">
            <h4 class="mb-0 font-weight-bold">Review Incomplete Transactions</h4>
            <hr>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-dark text-white d-flex align-items-center">
    <h5 class="mb-0">Incomplete Transactions</h5>

    <!-- Filters container pushed completely to the far right in Bootstrap 4 -->
    <div class="d-flex ml-auto">
        <input type="text" id="transactionSearch" class="form-control form-control-sm mr-2" placeholder="Search...">
        <select id="transactionFilter" class="form-control form-control-sm">
            <option value="">All Types</option>
            <option value="Stock Transfer">Stock Transfer</option>
            <option value="Sale">Sale</option>
            <option value="Purchase">Purchase</option>
        </select>
    </div>
</div>



        <div class="card-body p-0 table-responsive">
            <?php if (count($incompleteTransactions) > 0): ?>
                <table class="table table-bordered table-striped mb-0">
                    <thead class="thead-secondary">
                        <tr>
                            <th>#</th>
                            <th>Type</th>
                            <th>Transaction No</th>
                            <th>Date</th>
                            <th>Reference / Info</th>
                            <th style="text-align: center;">Items</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="transactionsBody">
                        <?php foreach ($incompleteTransactions as $i => $t): ?>
                            <tr data-type="<?= htmlspecialchars($t['transaction_type']) ?>">
                                <td><?= $i + 1 ?></td>
                                <td><?= htmlspecialchars($t['transaction_type']) ?></td>
                                <td><?= htmlspecialchars($t['transaction_id']) ?></td>
                                <td><?= htmlspecialchars(date('Y-m-d', strtotime($t['transaction_date']))) ?></td>
                                <td class="truncate"><?= htmlspecialchars($t['reference_info'] ?? '') ?></td>
                                <td style="text-align: center;"><?= htmlspecialchars($t['item_count']) ?></td>
                                <td>
                                    <a href="<?= htmlspecialchars($t['resume_url']) ?>" class="btn btn-sm btn-primary">
                                        Complete
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="p-3 text-center text-muted">No incomplete transactions found.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- jQuery + Bootstrap + AdminLTE + SweetAlert2 -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script src="../includes/plugins/sweetalert2/sweetalert2.all.min.js"></script>

<script>
    // Filter by transaction type
    const filterSelect = document.getElementById('transactionFilter');
const searchInput = document.getElementById('transactionSearch');
const rows = document.querySelectorAll('#transactionsBody tr');

function applyFilters() {
    const type = filterSelect.value.toLowerCase();
    const search = searchInput.value.toLowerCase();

    rows.forEach(row => {
        const typeMatch = !type || row.dataset.type.toLowerCase() === type;
        const text = row.textContent.toLowerCase();
        const searchMatch = !search || text.includes(search);

        row.style.display = (typeMatch && searchMatch) ? '' : 'none';
    });
}

filterSelect.addEventListener('change', applyFilters);
searchInput.addEventListener('input', applyFilters);

    
</script>



</body>
</html>
