<?php
include('menu_cashier.php');
include_once 'model/banking_model.php';

$banking_model = new banking_model();

// Get deposit ID from URL
$deposit_id = isset($_GET['deposit_id']) ? intval($_GET['deposit_id']) : 0;

if (!$deposit_id) {
    die("Invalid Deposit ID.");
}

// Fetch deposit details
$deposit = $banking_model->getDepositById($deposit_id);
?>

<style>

/* ===== Page title bar ===== */
.page-title-bar {
    background: linear-gradient(135deg, #007bff, #0056b3);
    border-radius: 10px;
    padding: 16px 20px;
    color: #fff;
    box-shadow: 0 4px 14px rgba(0,0,0,0.08);
}

/* Back button styling */
.back-btn {
    border-radius: 8px;
    font-weight: 600;
    padding: 6px 14px;
}

/* Better spacing between table rows */
.deposit-table th,
.deposit-table td {
    padding: 12px 8px;
    vertical-align: top;
}

/* Make labels fixed width */
.deposit-table th {
    width: 40%;
    font-weight: 600;
}

/* Premium amount styling */
.amount-box {
    background: linear-gradient(135deg, #f8f9fa, #eef3f7);
    border: 1px solid #dee2e6;
    border-radius: 10px;
}

/* Print styling */
@media print {

    .no-print,
    .main-sidebar,
    .main-header,
    .content-header {
        display: none !important;
    }

    .content-wrapper {
        margin-left: 0 !important;
    }

    .card {
        border: none !important;
        box-shadow: none !important;
    }
}

</style>

<div class="content-wrapper">

    <!-- ===== Stylish Page Header ===== -->
    <section class="content-header pb-2 no-print">
        <div class="container-fluid">

            <div class="page-title-bar d-flex justify-content-between align-items-center">

                <div>
                    <h4 class="mb-0 font-weight-bold">
                        <i class="fas fa-university mr-2"></i>
                        Bank Deposit Slip
                    </h4>
                    <small class="text-light opacity-75">
                        View and print deposit details
                    </small>
                </div>

                <div>
                    <button onclick="window.history.back();"
                            class="btn btn-light back-btn">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </button>
                </div>

            </div>

        </div>
    </section>

    <!-- ===== Main Content ===== -->
    <section class="content pt-3">
        <div class="container-fluid">

            <div class="row">
                <div class="col-md-8 col-lg-6">

                    <div class="card card-outline card-primary shadow-sm border-0">

                        <!-- Card Header -->
                        <div class="card-header bg-primary text-white py-3">
                            <h5 class="mb-0">
                                Simulated Bank Deposit Slip
                            </h5>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body px-4 py-4">

                            <!-- Reference -->
                            <div class="mb-4">
                                <small class="text-muted d-block mb-1">
                                    Deposit Reference
                                </small>
                                <strong class="h5">
                                    <?= htmlspecialchars($deposit['reference_number']) ?>
                                </strong>
                            </div>

                            <hr class="my-4">

                            <!-- Deposit Details -->
                            <table class="table table-borderless deposit-table">
                                <tr>
                                    <th class="text-muted">Deposit Date</th>
                                    <td>
                                        <?= date('d M Y', strtotime($deposit['date_deposited'])) ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Account Deposited</th>
                                    <td>
                                        <?= htmlspecialchars($deposit['account_name']) ?>
                                        <div class="small text-muted mt-1">
                                            <?= htmlspecialchars($deposit['account_number']) ?>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Deposited By</th>
                                    <td>
                                        <?= htmlspecialchars($deposit['deposited_by']) ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Deposit Location</th>
                                    <td>
                                        <?= htmlspecialchars($deposit['location']) ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Reference Number</th>
                                    <td>
                                        <?= htmlspecialchars($deposit['reference_number']) ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-muted">Narration</th>
                                    <td>
                                        <?= nl2br(htmlspecialchars($deposit['description'])) ?>
                                    </td>
                                </tr>
                            </table>

                            <hr class="my-4">

                            <!-- Amount Section -->
                            <div class="amount-box p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted font-weight-bold">
                                        Amount Deposited
                                    </span>
                                    <span class="h3 text-primary mb-0 font-weight-bold">
                                        MWK <?= number_format($deposit['amount_deposited'], 2) ?>
                                    </span>
                                </div>
                            </div>

                            <!-- Footer -->
                            <div class="mt-5 pt-3 border-top text-muted small">
                                <i>Simulated Bank Deposit Slip for reference only</i>.<br>
                                Generated by the <strong>Powertex LTD ERP</strong>.
                            </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>
</div>

<!-- REQUIRED SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/plugins/fontawesome-free/js/all.min.js"></script>
<script src="../includes/dist/js/adminlte.min.js"></script>