<?php 
include('menu_cashier.php');
include_once 'model/banking_model.php';
include_once 'model/branch_model.php';

$branch_model = new branch_model();
$banking_model = new banking_model();

$branchDetails = $branch_model->getBranchDetails($location);
$bank_deposits = $banking_model->getLastDeposits($location, 50); // get more records

$cash_summary    = $banking_model->getCashPaymentSummary($location);
$total_deposited = $banking_model->getTotalDeposited($location);
$total_expenses  = $banking_model->getRecordedExpenses($location);
$expenses_list   = $banking_model->getExpenseTransactions($location); 

$cash_payments_count = $cash_summary['count'] ?? 0;
$total_cash_payments = $cash_summary['total'] ?? 0;

$current_cash_balance = $total_cash_payments - $total_expenses - $total_deposited;

$total_amount = 0;
$deposit_count = 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Cash Deposits</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper">

    <!-- Content Header -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-3">
                <div class="col-sm-6">
                    <h4 class="font-weight-bold">
                        <i class="fas fa-book mr-2 text-primary"></i>
                        Bank Deposit Ledger - <?= $branchDetails['branch_name'] ?>
                    </h4>
                </div>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="content">
        <div class="container-fluid">

            <!-- Summary Cards -->
            <div class="row mb-4">

                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card bg-info h-100">
                        <div class="card-body">
                            <h6>Cash Payments</h6>
                            <h3><?= $cash_payments_count ?></h3>
                            <small>Transactions</small>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card bg-primary h-100">
                        <div class="card-body">
                            <h6>Total Cash Collected</h6>
                            <h3>MWK <?= number_format($total_cash_payments,2) ?></h3>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card bg-warning h-100">
                        <div class="card-body">
                            <h6>Total Cash Expenses</h6>
                            <h3>MWK<br> <?= number_format($total_expenses,2) ?></h3>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card bg-success h-100">
                        <div class="card-body">
                            <h6>Total Deposited</h6>
                            <h3>MWK <?= number_format($total_deposited,2) ?></h3>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card  h-100">
                        <div class="card-body">
                            <h6></h6>
                            <h3></h3>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-sm-6">
                    <div class="card <?= $current_cash_balance < 0 ? 'bg-danger' : 'bg-dark' ?> h-100">
                        <div class="card-body">
                            <h6>Cash Balance</h6>
                            <h3>MWK <?= number_format($current_cash_balance,2) ?></h3>
                        </div>
                    </div>
                </div>

            </div>


            <!-- Ledger Table -->
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h5 class="card-title mb-0">Cash Ledger</h5>
                </div>

                <div class="card-body table-responsive p-0">

            <?php
                $ledger = [];

                // STEP 1: Add Deposits as Credits (money leaving cash to bank)
                foreach ($bank_deposits as $deposit) {
                    $ledger[] = [
                        'date'        => $deposit['date_deposited'],
                        'reference'   => $deposit['reference_number'],
                        'description' => 'Bank Deposit',
                        'type'        => 'credit',  // cash out
                        'amount'      => $deposit['amount_deposited'],
                        'person'      => $deposit['deposited_by'],
                        'account'     => $deposit['account_name'],
                        'id'          => $deposit['deposit_id']
                    ];
                }

                // STEP 2: Add Expenses as Debits (cash spent)
                foreach ($expenses_list as $expense) {
                    $ledger[] = [
                        'date'        => $expense['expense_date'],
                        'reference'   => $expense['reference_number'],
                        'description' => $expense['expense_description'],
                        'type'        => 'debit',   // cash spent
                        'amount'      => $expense['amount_paid'],
                        'person'      => $expense['recorded_by'],
                        'account'     => 'Cash Expense',
                        'id'          => $expense['id']
                    ];
                }

                // STEP 3: Sort ledger oldest first
                usort($ledger, function($a, $b) {
                    return strtotime($a['date']) - strtotime($b['date']);
                });

                // STEP 4: Calculate running balance starting from total cash collected
                $running_balance = $total_cash_payments;

                foreach ($ledger as &$entry) {
                    if ($entry['type'] == 'credit') {
                        // Bank deposit reduces cash on hand
                        $running_balance -= $entry['amount'];
                    } else {
                        // Expenses reduce cash on hand
                        $running_balance -= $entry['amount'];
                    }
                    $entry['running_balance'] = $running_balance;
                }
                unset($entry);

                // STEP 5: Reverse for display (newest first)
                $ledger = array_reverse($ledger);


            if (!empty($ledger)) {
            ?>

            <table class="table table-hover table-striped table-sm">
                <thead class="bg-light">
                    <tr>
                        <th>Date</th>
                        <th>Reference</th>
                        <th>Description</th>
                        <th>Person</th>
                        <th class="text-right">Expenses</th>
                        <th class="text-right">Deposits</th>
                        <th class="text-right">Balance (MWK)</th>
                        <th class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>

                <?php foreach($ledger as $row): ?>
                    <tr>
                        <td><?= date('d M Y', strtotime($row['date'])) ?></td>

                        <td class="font-weight-bold text-primary">
                            <?= htmlspecialchars($row['reference']) ?>
                        </td>

                        <td><?= htmlspecialchars($row['description']) ?></td>

                        <td><?= htmlspecialchars($row['person']) ?></td>

                        <!-- Debit -->
                        <td class="text-right text-danger font-weight-bold">
                            <?= $row['type'] == 'debit' ? number_format($row['amount'],2) : '-' ?>
                        </td>

                        <!-- Credit -->
                        <td class="text-right text-success font-weight-bold">
                            <?= $row['type'] == 'credit' ? number_format($row['amount'],2) : '-' ?>
                        </td>

                        <!-- Running Balance -->
                        <td class="text-right font-weight-bold <?= $row['running_balance'] < 0 ? 'text-danger' : 'text-dark' ?>">
                            <?= number_format($row['running_balance'],2) ?>
                        </td>

                        <!-- Action Buttons -->
                        <td class="text-center">

                            <?php if($row['type'] == 'credit'): ?>
                                <a href="bank_deposit_slip.php?deposit_id=<?= $row['id'] ?>" 
                                class="btn btn-sm btn-primary">
                                    <i class="fas fa-file-invoice"></i>
                                </a>
                            <?php else: ?>
                                <a href="view_expense_slip.php?id=<?= $row['id'] ?>"
                                class="btn btn-sm btn-danger">
                                    <i class="fas fa-receipt"></i>
                                </a>
                            <?php endif; ?>

                        </td>

                    </tr>
                <?php endforeach; ?>

                </tbody>
            </table>

            <?php } else { ?>

            <div class="p-4 text-center text-muted">
                No ledger records found.
            </div>

            <?php } ?>

                </div>
            </div>

        </div>
    </section>
</div>

<!-- REQUIRED SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/plugins/fontawesome-free/js/all.min.js"></script>
<script src="../includes/dist/js/adminlte.min.js"></script>

<style>
.table th, .table td {
    padding: 10px;
    vertical-align: middle;
}

.card.bg-info, .card.bg-success {
    color: #fff;
}
</style>