<?php
session_start();
header('Content-Type: application/json');

require_once '../model/documents_model.php';
require_once '../services/DocumentSender.php';

$documents_model = new documents_model();
$sender          = new DocumentSender();

$response = [
    'success' => false,
    'message' => 'Invalid request'
];

// 1️⃣ Basic validation
$channel   = $_POST['channel'] ?? null;
$docType   = $_POST['document_type'] ?? null;
$reference = $_POST['reference'] ?? null;

if (!$channel || !$docType || !$reference) {
    echo json_encode([
        'success' => false,
        'message' => 'Missing required parameters.'
    ]);
    exit;
}

// 2️⃣ Allowed channels
$allowedChannels = ['whatsapp', 'email'];
if (!in_array($channel, $allowedChannels)) {
    echo json_encode([
        'success' => false,
        'message' => 'Unsupported sending channel.'
    ]);
    exit;
}

// 3️⃣ Allowed document types
$allowedDocuments = [
    'cash_sale',
    'invoice',
    'quotation',
    'sales_order',
    'customer_delivery_note',
    'invoice_payment'
];

if (!in_array($docType, $allowedDocuments)) {
    echo json_encode([
        'success' => false,
        'message' => 'Unsupported document type.'
    ]);
    exit;
}

try {

    // 4️⃣ Load document data
    $document = $documents_model->getDocumentData($docType, $reference);

    // 5️⃣ Send document
    $result = $sender->send($channel, $document);

    echo json_encode([
        'success' => true,
        'message' => $result['message'],
        'debug'   => $result['debug'] ?? null
    ]);
    exit;

} catch (PHPMailer\PHPMailer\Exception $e) {
    // Handle email-specific errors
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
    exit;

} catch (Exception $e) {
    // All other errors
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
    exit;
}

