<?php 
include('menu_cashier.php');
include_once 'model/sales_model.php';

$sales_model = new sales_model();
$open_invoices = $sales_model->fetchInvoices($location, [0,1]); // Fetch open invoices
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Open Invoices</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <style>
.table-modern {
    border-collapse: separate;
    border-spacing: 0 8px;
}

.table-modern tbody tr {
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    border-radius: 8px;
}

.table-modern tbody tr td {
    padding: 14px 12px;
    vertical-align: middle;
    border: none !important;
}

.table-modern thead th {
    background: #004085;
    color: #fff;
    border: none;
    padding: 12px;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 30px;
    font-weight: bold;
    font-size: 13px;
}

.status-unpaid {
    background: #dc3545;
    color: #fff;
}

.status-partial {
    background: #ffc107;
    color: #000;
}

.status-paid {
    background: #28a745;
    color: #fff;
}

.btn-view {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 13px;
}

.table-modern tbody tr:hover {
    transform: scale(1.01);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transition: 0.15s ease-in-out;
}
</style>

</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Open Invoices</h3>

        <!-- Search filter -->
        <input type="text" id="filter_global" class="form-control w-25" placeholder="Search Invoices...">
    </div>

    <!-- Open Invoices Table -->
    <div class="table-responsive">
        <table class="table table-modern" id="invoicesTable">

            <thead class="thead-dark">
                <tr>
                    <th>Invoice Number</th>
                    <th>Customer</th>
                    <th>Date</th>
                    <th>Total Amount</th>
                    <th>Paid Amount</th>
                    <th>Outstanding</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $totalOutstanding = 0;
                foreach($open_invoices as $inv): 
                    $outstanding = $inv['total_bill'] - $inv['paid_amount'];
                    $totalOutstanding += $outstanding;
                    
                    // Status background class
                    if($inv['order_state'] == 0) $statusClass = 'bg-danger text-white';
                    elseif($inv['order_state'] == 1) $statusClass = 'bg-warning';
                    elseif($inv['order_state'] == 2) $statusClass = 'bg-success text-white';
                    else $statusClass = '';
                ?>
                    <tr>
                        <td><?= htmlspecialchars($inv['order_number']) ?></td>
                        <td><?= htmlspecialchars($inv['customer_name']) ?></td>
                        <td><?= htmlspecialchars(date('d-m-Y', strtotime($inv['invoice_date']))) ?></td>
                        <td class="text-right"><?= number_format($inv['total_bill'],2) ?></td>
                        <td class="text-right"><?= number_format($inv['paid_amount'],2) ?></td>
                        <td class="text-right"><?= number_format($outstanding,2) ?></td>
                        <td class="text-center">
                            <?php if($inv['order_state'] == 0): ?>
                                <span class="status-badge status-unpaid">Unpaid</span>
                            <?php elseif($inv['order_state'] == 1): ?>
                                <span class="status-badge status-partial">Partially Paid</span>
                            <?php else: ?>
                                <span class="status-badge status-paid">Fully Paid</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <a href="customer_invoice.php?invoice_number=<?= $inv['order_number'] ?>" 
   class="btn btn-primary btn-view">
    <i class="fa fa-eye"></i> View
</a>

                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>

            <!-- Total Outstanding Row -->
            <tfoot>
<tr style="background:#f8f9fa; font-weight:bold;">
    <td colspan="5" class="text-right">Total Outstanding:</td>
    <td class="text-right text-danger"><?= number_format($totalOutstanding,2) ?></td>
    <td colspan="2"></td>
</tr>
</tfoot>

        </table>
    </div>

</div>

<!-- Scripts -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>

<script>
    // Global search filter
    $("#filter_global").on("keyup", function(){
        let value = $(this).val().toLowerCase();
        $("#invoicesTable tbody tr").filter(function(){
            $(this).toggle($(this).text().toLowerCase().includes(value));
        });
    });
</script>

</body>
</html>
