<?php 
    include('menu_cashier.php');
    include_once 'model/stock_model.php';
    include_once 'model/branch_model.php';

    $stock_model = new stock_model();
    $branch_model = new branch_model();

    // Default date = current month
    $start_date = $_GET['start'] ?? date("Y-m-01");
    $end_date   = $_GET['end'] ?? date("Y-m-t");

    $stock_sheet = $stock_model->getstockSheet($location, $start_date, $end_date);
    $branchDetails = $branch_model->getBranchDetails($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex || Stock Sheets</title>

<link rel="icon" type="image/png" href="../finance/images/favicon.png">

</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
        <!-- Title -->
        <h3 class="mb-0">
            Stock Sheet  
            <span class="text-primary"> - <?= htmlspecialchars($branchDetails['branch_name'] ?? "") ?></span>
        </h3>

        <!-- DATE RANGE FILTER + ACTIONS -->
        <form id="stockForm" method="POST" class="form-inline">

            <div class="form-group mb-0 mr-2 position-relative">
                <label class="mr-1">Start Date</label>
                <div class="input-group">
                    <input type="date" name="start_date" class="form-control form-control-sm pl-2" value="<?= $start_date ?>">
                    <div class="input-group-append">
                        <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                    </div>
                </div>
                <input type="hidden" name="stock_sheets_pdf" value="stock_sheets_pdf">
            </div>

            <!-- End Date -->
            <div class="form-group mb-0 mr-2 position-relative">
                <label class="mr-1">End Date</label>
                <div class="input-group">
                    <input type="date" name="end_date" class="form-control form-control-sm pl-2" value="<?= $end_date ?>">
                    <div class="input-group-append">
                        <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                    </div>
                </div>
            </div>

            <!-- Load Button -->
            <div class="form-group mb-0 mr-2">
                <button type="submit" class="btn btn-primary">Load</button>
            </div>

            <!-- Generate PDF -->
            <div class="form-group mb-0">
                <button type="button" id="pdfBtn" class="btn btn-danger">
                    <span id="pdfText">Generate PDF</span>
                    <span id="pdfSpinner" class="spinner-border spinner-border-sm ml-2 d-none"></span>
                </button>
            </div>

            <!-- Hidden inputs -->
            <input type="hidden" name="stock_sheet" value="stock_sheet">
            <input type="hidden" name="start_date" value="<?= $start_date ?>">
            <input type="hidden" name="end_date" value="<?= $end_date ?>">
            <input type="hidden" name="location" value="<?= $location ?>">

        </form>
    </div>








    <div class="table">
        <table class="table table-bordered table-striped" id="stockTable">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Category</th>
                    <th class="text-center">Opening&nbsp;Stock</th>
                    <th class="text-center">Transfer In</th>
                    <th class="text-center">Total</th>
                    <th class="text-center">Transfer&nbsp;Out</th>
                    <th class="text-center">Sold</th>
                    <th class="text-center">Total&nbsp;Out</th>
                    <th class="text-center">Closing&nbsp;Stock</th>
                    <th class="text-center">Current&nbsp;Quantity</th>

                </tr>
            </thead>

            <tbody>
                <?php foreach ($stock_sheet as $s): 
                    $opening = (int)$s['opening_stock'];
                    $in = (int)$s['transfer_in'];
                    $out = (int)$s['transfer_out'];
                    $sold = (int)$s['sold'];
                    $current = (int)$s['current_qty'];

                    $total_in = $opening + $in;
                    $total_out = $out + $sold;
                    $closing = $opening + $in - $out - $sold;
                ?>
                <tr>
                    <td><?= $s['product_name'] ?></td>
                    <td><?= $s['categoryname'] ?></td>
                    <td class="text-center"><?= $opening ?></td>
                    <td class="text-center"><?= $in ?></td>
                    <td class="fw-bold text-success text-center"><?= $total_in ?></td>
                    <td class="text-center"><?= $out ?></td>
                    <td class="text-center"><?= $sold ?></td>
                    <td class="fw-bold text-danger text-center"><?= $total_out ?></td>
                    <td class="fw-bold text-center"><?= $closing ?></td>
                    <td class="fw-bold text-center"><?= $current ?></td>

                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<!-- DO NOT REMOVE THESE, PRESERVED EXACTLY -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
$(document).ready(function () {

    // Custom category order
    const categoryOrder = {
        "car batteries": 1,
        "solar batteries": 2,
        "inverters": 3,
        "solar panels": 4,
        "accessories": 5
    };


    // Register custom ordering plugin
    $.fn.dataTable.ext.order['category-order'] = function (settings, col) {
        return this.api()
            .column(col, { order: 'index' })
            .nodes()
            .map(function (td) {
                let text = $(td).text().trim().toLowerCase();
                return categoryOrder[text] ?? 999; // unknown categories go last
            });
    };

    // Initialize DataTable
    $('#stockTable').DataTable({
        paging: true,
        searching: true,
        info: true,
        ordering: true,

        lengthMenu: [
            [25, 50, 100, 250, 500, -1],
            [25, 50, 100, 250, 500, "All"]
        ],

        pageLength: 500,

        columnDefs: [
            {
                targets: 1, // Category column index
                orderDataType: 'category-order'
            }
        ],

        order: [[1, 'asc']] // Default sort by category
    });


});
</script>


<script>
// GLOBAL SEARCH FILTER
$("#filter_global").on("keyup", function () {
    let value = $(this).val().toLowerCase();
    $("#stockTable tbody tr").filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
});
</script>

<script>
document.getElementById('pdfBtn').addEventListener('click', function() {

    let btn = document.getElementById("pdfBtn");

    // Disable button
    btn.disabled = true;

    // Change text
    document.getElementById("pdfText").innerText = "Generating...";

    // Show spinner
    document.getElementById("pdfSpinner").classList.remove("d-none");

    // Submit form
    const form = document.getElementById('stockForm');
    form.action = 'generate_pdf.php';
    form.method = 'POST';
    form.submit();

    // Auto re-enable button in case download event isn't detected
    setTimeout(function(){
        btn.disabled = false;
        document.getElementById("pdfText").innerText = "Generate PDF";
        document.getElementById("pdfSpinner").classList.add("d-none");
    }, 8000); // safe timeout
});
</script>


</body>
</html>
