<?php
session_start();
header('Content-Type: application/json');

include_once 'model/users_model.php';

$response = ['valid' => false, 'message' => ''];

// Ensure session is valid
if (!isset($_SESSION['sess_username'])) {
    $response['message'] = 'Session expired. Please log in again.';
    echo json_encode($response);
    exit;
}

$username = $_SESSION['sess_username'];
$users_model = new users_model();

$currentPassword = $_POST['current_password'] ?? '';

if (empty($currentPassword)) {
    $response['message'] = 'Password input is required.';
    echo json_encode($response);
    exit;
}

// Get hashed password from DB
$hashed_password = $users_model->getPasswordByUsername($username); 

if ($hashed_password === null) {
    $response['message'] = 'User not found.';
} else {
    if (password_verify($currentPassword, $hashed_password)) {
        $response['valid'] = true;
        $response['message'] = 'Password is correct.';
    } else {
        $response['message'] = 'Current password is incorrect.';
    }
}

echo json_encode($response);
