<?php
// Include necessary files, database models, and other required setups
include_once 'model/orders_model.php';  // Assuming you have an invoice model
include_once 'model/customers_model.php';  // If necessary for fetching customer details

$orders_model = new orders_model();
$customers_model = new customers_model();

// Fetch open invoices
$open_invoices = $orders_model->getallInvoices();

// Initialize total amount due
$total_amount_due = 0;
$total_amount_paid = 0;
$total_current_balance = 0;

// Loop through invoices to calculate the total amount due
foreach ($open_invoices as $invoice) {
    $total_amount_due += $invoice['total_bill'];
    $total_amount_paid += $invoice['total_paid'];
    $total_current_balance += $invoice['current_balance'];
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />
    <title>Powertex LTD - Open Invoices</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php include 'menu_finance.php'; ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>Invoices </small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12 ">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Open Invoices</h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">Open Invoices Overview</h5>
                                    </div>

                                    <!-- Right side: Back Button -->
                                    <ul class="nav navbar-right panel_toolbox mb-0">
                                        <li>
                                            <a class="dropdown-item" href="dashboard.php">
                                                <button class="btn btn-secondary btn-sm">
                                                    <i class="fa fa-arrow-left"></i> Back
                                                </button>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                          
                                                <?php if (!empty($open_invoices)) { ?>
                                                    <table class="table table-bordered table-sm">
                                                        <thead>
                                                            <tr>
                                                                
                                                                <th>Invoice Date</th>
                                                                <th>Invoice Number</th>
                                                                <th>Customer Name</th>
                                                                <th>Due Date</th>
                                                                <th>Status</th>                                                                
                                                                <th>Total</th>
                                                                <th>Amount Paid</th>
                                                                <th>Current Balance</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($open_invoices as $invoice) { ?>
                                                                <tr>
                                                                    
                                                                    <td><?php echo date('d F Y', strtotime($invoice['orderdate'])); ?></td>
                                                                    <td><?php echo htmlspecialchars($invoice['order_number']); ?></td>
                                                                    <td><?php echo htmlspecialchars($invoice['customer_name']); ?></td>
                                                                    <td><?php echo date('d F Y', strtotime($invoice['due_date'])); ?></td>
                                                                    <td class="<?php
                                                                        // Adding color-coding based on invoice status
                                                                        $status = $invoice['invoice_state'];
                                                                        switch ($status) {
                                                                            case 0:
                                                                                echo 'bg-warning text-dark'; // Pending or unpaid invoices
                                                                                break;
                                                                            case 1:
                                                                                echo 'bg-info text-white'; // Pending or unpaid invoices
                                                                                break;
                                                                            case 2:
                                                                                echo 'bg-success text-white'; // Paid invoices
                                                                                break;
                                                                            case 3:
                                                                                echo 'bg-danger text-white'; // Cancelled invoices
                                                                                break;
                                                                            default:
                                                                                echo '';
                                                                        }
                                                                    ?>">
                                                                        <?php echo htmlspecialchars(ucfirst($invoice['invoice_status'])); ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php echo number_format($invoice['total_bill'], 2); ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php echo number_format($invoice['total_paid'], 2); ?>
                                                                    </td>
                                                                    <td style="text-align: right;">
                                                                        <?php echo number_format($invoice['current_balance'], 2); ?>
                                                                    </td>

                                                                    <td>
                                                                        <?php
                                                                            $url = "invoice.php?invoice_number=" . $invoice['order_number'];
                                                                        ?>

                                                                        <a href="<?php echo $url; ?>" class="btn btn-info btn-sm" title="View Invoice Details">
                                                                            <i class="fa fa-receipt"></i>
                                                                        </a>
                                                                        
                                                                        <button 
                                                                            class="btn btn-danger btn-sm cancel-invoice-btn" 
                                                                            data-invoice="<?= $invoice['order_number'] ?>" 
                                                                            data-customer="<?= htmlspecialchars($invoice['customer_name']) ?>"
                                                                            data-date="<?= date('d M Y', strtotime($invoice['orderdate'])) ?>"
                                                                            data-amount="<?= $invoice['total_paid'] ?>"
                                                                            data-total="<?= number_format($invoice['total_bill'], 2) ?>"
                                                                            data-state="<?= $invoice['order_state'] ?>"
                                                                            title="Cancel Invoice">
                                                                            <i class="fa fa-times-circle"></i>
                                                                        </button>


                                                                        <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                            <button class="btn btn-info btn-sm">
                                                                                <i class="fa fa-cog"></i>
                                                                            </button>
                                                                        </a>
                                                                    </td>
                                                                    
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <!-- Footer Row with Totals -->
                                                        <tfoot>
                                                            <tr>
                                                                <td colspan="5" class="text-right"><strong>Total Amount Due</strong></td>
                                                                <td class="text-right"><strong><?php echo number_format($total_amount_due, 2); ?></strong></td>
                                                                <td class="text-right"><strong><?php echo number_format($total_amount_paid, 2); ?></strong></td>
                                                                <td class="text-right"><strong><?php echo number_format($total_current_balance, 2); ?></strong></td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                <?php } else { ?>
                                                    <div class="alert alert-info">
                                                        No open invoices available.
                                                    </div>
                                                <?php } ?>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
    <script>
        function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
        }
    </script>
    <script>
        $(document).on('click', '.cancel-invoice-btn', function () {
            const invoiceNumber = $(this).data('invoice');
            const customerName = $(this).data('customer') || 'Unknown';
            const invoiceDate = $(this).data('date') || 'N/A';
            const totalAmount = $(this).data('total') || '0.00';
            const amountPaid = parseFloat($(this).data('amount'));
            const orderState = parseInt($(this).data('state')); // must be passed from PHP
            const cancelState = 3;

            // Step 1: Check the state before opening confirmation popup
            if (orderState === 3) {
                Swal.fire({
                    icon: 'info',
                    title: 'Already Cancelled',
                    text: 'This invoice has already been cancelled.',
                });
                return;
            }

            if (orderState === 2) {
                Swal.fire({
                    icon: 'info',
                    title: 'Fully Paid Invoice',
                    text: 'This invoice is fully paid and cannot be cancelled.',
                });
                return;
            }

            if (orderState === 1) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Partial Payment',
                    text: 'This invoice has partial payments. Cancellation is not allowed.',
                });
                return;
            }

            // Step 2: Show the cancellation confirmation popup (only for order_state == 0)
            Swal.fire({
                title: 'Cancel Invoice',
                html: `
                    <div style="text-align: left; font-size: 15px;">
                        <p><strong>🧾 Invoice Number:</strong> ${invoiceNumber}</p>
                        <p><strong>👤 Customer:</strong> ${customerName}</p>
                        <p><strong>📅 Date:</strong> ${invoiceDate}</p>
                        <p><strong>💰 Total Amount:</strong> MWK ${totalAmount}</p>
                        <hr>
                        <p class="text-danger" style="color:#e74c3c;"><strong>Note:</strong> This action <u>cannot</u> be undone!</p>
                        <p style="color:#e67e22;">If any payments have been made, cancellation will be blocked.</p>
                        <p style="color:#3498db;">If not, the stock will be reversed and the invoice will be voided.</p>
                        <input id="cancelReason" class="form-control" placeholder="Reason for cancelling the invoice">
                    </div>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, Proceed',
                cancelButtonText: 'Cancel',
                focusConfirm: false,
                preConfirm: () => {
                    const reason = document.getElementById('cancelReason').value.trim();
                    if (!reason) {
                        Swal.showValidationMessage('⚠️ Please provide a reason for cancellation.');
                    }
                    return reason;
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    if (amountPaid > 0) {
                        Swal.fire({
                            icon: 'error',
                            title: '❌ Cannot Cancel Invoice',
                            text: 'This invoice cannot be cancelled because a payment has already been made.',
                            confirmButtonColor: '#e74c3c'
                        });
                    } else {
                        const reason = encodeURIComponent(result.value);
                        window.location.href = `controllers/orders_controller.php?action=cancelinvoice&order_state=${cancelState}&invoice_number=${invoiceNumber}&reason=${reason}`;
                    }
                }
            });
        });
    </script>




</body>
</html>
