<?php
    date_default_timezone_set('Africa/Blantyre'); // or your preferred timezone


    session_start();
    require_once 'model/stock_model.php';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $type = $_POST['type'] ?? '';
        $location_id = $_POST['id'] ?? 0;
        $product_ids = $_POST['product_ids'] ?? [];
        $opening_stock = $_POST['opening_stock'] ?? [];
        $min_stock = $_POST['min_stock'] ?? [];
        $datecaptured = date('Y-m-d H:i:s');
        $operator = $_SESSION['sess_employeecode'];
        $product_state = 1;

        if (!empty($product_ids) && in_array($type, ['warehouse', 'branch'])) {
            $stock_model = new stock_model(); // use your actual model

            foreach ($product_ids as $pid) {
                $stock = isset($opening_stock[$pid]) ? (int)$opening_stock[$pid] : 0;
                $min_level = isset($min_stock[$pid]) ? (int)$min_stock[$pid] : 0;
                
                // Save each product with its stock
                $stock_model->linkSingleProductToLocation($type, $location_id, $pid, $stock, $stock, $min_level, $datecaptured, $operator, $product_state);
            }

            // Success response
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Products attached successfully.'
            ];
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Please select atleast 1 product to attach.'
            ];
            header("Location: bulk_assign.php");
            exit;
        }
        if($type == 'warehouse'){
            header("Location: manage_warehouses.php");
            exit;
        }elseif($type == 'branch'){
            header("Location: manage_branches.php");
            exit;
        }
        
    }
?>
