<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          
          <?php
            include 'menu_finance.php';
            include_once 'model/branch_model.php';

            if(isset($_GET['id'])){

              $branch_id = $_GET['id'];

              $branch_model = new branch_model();
              $branchDetails = $branch_model->getBranchDetails($branch_id);
              $branch_stock = $branch_model->branch_stock($branch_id);
            }

            

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="page-title">
                <div class="title_left">
                  <h3><small><?php echo $branchDetails['branch_name']?> </small></h3>
                </div>

                <div class="title_right">
                  
                </div>
              </div>
              <div class="clearfix"></div>
              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Stock Items</h2>
                      <ul class="nav navbar-right panel_toolbox d-flex align-items-center" style="gap: 10px;">
                      <li>
                          <a class="dropdown-item">
                            <form name="export_branchstock" action="generate_pdf.php" method="post" class="mb-0">
                              <input type="hidden" name="branch_id" value="<?php echo $branch_id?>" readonly>
                              <input type="hidden" name="branch_stock" value="branch_stock">
                              <button class="btn btn-info" type="submit">Export To PDF</button>
                            </form>
                            
                          </a>
                        </li>
                        <li>
                          <button class="btn btn-info" onclick="history.back();">
                            <i class="fa fa-arrow-left"></i> Back
                          </button>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                      <div class="row">
                        <div class="col-sm-12">
                          <table id="warehouse_stock" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                               <tr>
                                <th>Product Name</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th style="text-align: center;">Branch</th>
                                <th style="text-align: center;">Opening Stock</th>
                                <th style="text-align: center;">Minimum Stock Level</th>
                                <th style="text-align: center;">Quantity</th>
                                <th style="text-align: center;">Selling Price</th>
                                <th>Action</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php
                                foreach($branch_stock as $stock):
                              ?>
                                <?php
                                  // Determine row class based on quantity
                                  if ($stock['quantity'] == 0) {
                                      $rowClass = 'bg-danger text-white';
                                  } elseif ($stock['quantity'] < $stock['min_order_level']) {
                                      $rowClass = 'bg-warning';
                                  } else {
                                      $rowClass = '';
                                  }
                              ?>
                              <tr class="<?= $rowClass ?>">
                                  <td><?php echo $stock['product_name'] ?></td>
                                  <td><?php echo $stock['categoryname'] ?></td>
                                  <td><?php echo $stock['unitname'] ?></td>
                                  <td><?php echo $stock['branch_name'] ?></td>
                                  <td style="text-align: center;"><?php echo $stock['opening_stock'] ?></td>
                                  <td style="text-align: center;"><?php echo $stock['min_order_level'] ?></td>
                                  <td style="text-align: center;"><?php echo $stock['quantity'] ?></td>
                                  <td style="text-align: right;"><?php echo $stock['selling_price'] ?></td>
                                  <td>
                                      <a href="branch_item_breakdown.php?branch_id=<?= $stock['branch_id'] ?>&product_id=<?= $stock['product_id'] ?>">
                                          <button class="btn btn-info btn-sm" title="Breakdown Item Transfers" ><i class="fa fa-tasks"></i></button>
                                      </a>

                                     

                                      <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                          <button class="btn btn-info btn-sm" title="Item & Branch Configurations"><i class="fa fa-cog"></i></button>
                                      </a>
                                  </td>
                              </tr>

                              <?php
                                endforeach;
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->
          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>
      <?php
        include_once 'libraries.php';
      ?>
      <script>
            function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
          }
        </script>
      
    <script>
        $(document).ready(function () {
            let table = $('#warehouse_stock').DataTable({
                responsive: true,
                ordering: true,
                pageLength: 50,
                columnDefs: [
                    {
                        targets: -1, // Assuming "Action" is the last column; use correct index if different
                        width: "150px",
                        className: "text-center",
                        orderable: false // Usually actions shouldn't affect sorting
                    }
                ]
            });

            // Search across all columns using external input
            $('#search_query').on('keyup', function () {
                table.search(this.value).draw();
            });
        });
    </script>
    </body>
  </html>