<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
                include_once 'model/stock_model.php';
                include_once 'model/companies_model.php';

                $stock_model = new  stock_model();
                $companies_model = new companies_model();

                if(isset($_GET['product_id']) && isset($_GET['company_id'])){
                    $product_id = $_GET['product_id'];
                    $company_id = $_GET['company_id'];
                }
                $productDetails = $stock_model->getProductDetailsbyID($product_id);
                $productsList = $companies_model->getProductBreakdown($company_id, $product_id);

            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Third party Products Management </small></h3>
                                </div>

                                <div class="title_right">
                    
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>Breakdown of all transfers for <?= $productDetails['product_name']?></h2>
                                            <ul class="nav navbar-right panel_toolbox">
                                                <li>
                                                    <button class="btn btn-warning btn-sm" onclick="history.back()">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </li>
                                            </ul>
                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <table class="table table-striped table-bordered">
                                                       <thead class="bg-success text-white text-center">
                                                            <th>Date</th>
                                                            <th>Product Name</th>
                                                            <th>Category</th>
                                                            <th>Opening Stock</th>
                                                            <th>Direction</th>
                                                            <th>Quantity</th>
                                                            <th>Closing Stock</th>
                                                        </thead>
                                                        <tbody>
                                                            <?php if (!empty($productsList)): ?>
                                                                <?php foreach ($productsList as $i => $list): ?>
                                                                    <?php
                                                                            $bg_class = $list['direction'] === 'Transfer In' 
                                                                                        ? 'bg-success text-white font-weight-bold' 
                                                                                        : 'bg-danger text-white font-weight-bold';
                                                                        ?>
                                                                    <tr>
                                                                        <td><?= date('d M Y H:i', strtotime($list['date'])) ?></td>
                                                                        <td><?= htmlspecialchars($list['product_name']) ?></td>
                                                                        <td><?= htmlspecialchars($list['categoryname']) ?></td>
                                                                        <td class="text-center"><?= number_format($list['opening_stock'], 0) ?></td>
                                                                        <td class="text-center <?= $bg_class ?>">
                                                                            <?= $list['direction'] ?>
                                                                        </td>
                                                                        <td class="text-center"><?= number_format($list['quantity'], 0) ?></td>
                                                                        <td class="text-center"><?= number_format($list['closing_stock'], 0) ?></td>
                                                                    </tr>
                                                                <?php endforeach; ?>
                                                            <?php else: ?>
                                                                <tr>
                                                                    <td colspan="7" class="text-center text-muted">No stock transfer records found for this product.</td>
                                                                </tr>
                                                            <?php endif; ?>
                                                        </tbody>

                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
        </body>
    </html>
