<?php
include_once 'model/stock_model.php';
$stock_model = new stock_model();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Powertex LTD - Product Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once 'css_links.php'; ?>
    <style>
        body {
            background: #f4f6f9;
        }
        .card {
            border-radius: 10px;
        }
        .page-title h3 {
            font-weight: 600;
        }
        #productList table {
            font-size: 14px;
        }
    </style>
</head>
<body class="nav-md">
<div class="container body">
    <div class="main_container">
        <?php include 'menu_finance.php'; ?>

        <!-- Page content -->
        <div class="right_col" role="main">
            <div class="">
                <div class="page-title">
                    <div class="title_left">
                        <h3><small>Attach Products to Warehouse / Branch</small></h3>
                    </div>
                </div>
                <div class="clearfix"></div>

                <div class="row">
                    <div class="col-md-10 offset-md-1 col-sm-12">
                        <div class="card p-4 shadow-sm">
                            <form>
                                <div class="form-group">
                                    <label for="locationSelect">Select Warehouse or Branch:</label>
                                    <select id="locationSelect" class="form-control">
                                        <option value="">-- Select Location --</option>
                                        <optgroup label="Warehouses">
                                            <?php
                                            $warehouses = $stock_model->getWarehouses();
                                            foreach ($warehouses as $wh) {
                                                echo "<option value='warehouse_{$wh['warehouse_id']}'>" . htmlspecialchars($wh['warehouse_name']) . "</option>";
                                            }
                                            ?>
                                        </optgroup>
                                        <optgroup label="Branches">
                                            <?php
                                            $branches = $stock_model->getBranches();
                                            foreach ($branches as $br) {
                                                echo "<option value='branch_{$br['branch_id']}'>" . htmlspecialchars($br['branch_name']) . "</option>";
                                            }
                                            ?>
                                        </optgroup>
                                    </select>
                                </div>
                            </form>

                            <div id="productList" class="mt-4">
                                <p class="text-muted">Select a warehouse or branch to load available products...</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- /Page content -->

        <?php include_once 'footer.php'; ?>
    </div>
</div>

<?php include_once 'libraries.php'; ?>

<!-- Custom script -->
<script>
    $(document).ready(function () {
        $('#locationSelect').on('change', function () {
            const value = $(this).val();

            if (value !== '') {
                const [type, id] = value.split('_');

                $.ajax({
                    url: 'get_unlinked_products.php',
                    type: 'POST',
                    data: {type, id},
                    success: function (data) {
                        $('#productList').html(data);
                    },
                    error: function () {
                        $('#productList').html('<p class="text-danger">Failed to load data.</p>');
                    }
                });
            } else {
                $('#productList').html('<p class="text-muted">Select a warehouse or branch to load available products...</p>');
            }
        });
    });
</script>
</body>
</html>
