<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />

            <title>Powertex LTD - User Profile</title>
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php 
                        include 'menu_finance.php'; 
                        include_once 'model/users_model.php';

                        $username = $_SESSION['sess_username'];

                        $users_model = new users_model();
                        $user = $users_model->getuserDetails($username);

                        
                    ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>User Profile</small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="card card-info">
                                        <div class="card-header bg-info text-white">
                                            <h5 class="card-title mb-0">Change Password</h5>
                                        </div>
                                        <div class="card-body">
                                            <form id="changePasswordForm" action="controllers/users_controller.php" method="post">
                                                <div class="form-group">
                                                    <label>Full Name</label>
                                                    <input type="text" class="form-control" value="<?= htmlspecialchars($user['fullname']) ?>" readonly>
                                                </div>

                                                <div class="form-group">
                                                    <label>Username</label>
                                                    <input type="text" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" readonly>
                                                </div>

                                                <div class="form-group">
                                                    <label>Role</label>
                                                    <input type="text" class="form-control" value="<?= htmlspecialchars($user['role']) ?>" readonly>
                                                </div>

                                                <input type="hidden" name="employee_code" value="<?= htmlspecialchars($user['employee_code']) ?>">
                                                <input type="hidden" name="action" value="change_password">

                                                <div class="form-group">
                                                    <label>Current Password</label>
                                                    <input type="password" class="form-control" name="current_password" id="current_password" required>
                                                    <small id="currentPasswordStatus" class="form-text text-danger" style="display: none;"></small>
                                                </div>

                                                <div class="form-group">
                                                    <label>New Password</label>
                                                    <input type="password" class="form-control" name="new_password" id="new_password" minlength="5" required>
                                                </div>

                                                <div class="form-group">
                                                    <label>Re-enter New Password</label>
                                                    <input type="password" class="form-control" id="confirm_password" minlength="5" required>
                                                    <small id="passwordMatchStatus" class="form-text text-danger" style="display: none;"></small>
                                                </div>

                                                <button type="submit" class="btn btn-success" id="submitBtn">Update Password</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php include_once 'footer.php'; ?>
                </div>
            </div>

            <?php include_once 'libraries.php'; ?>
            <script>
$(document).ready(function () {
    $('#changePasswordForm').on('submit', function (e) {
        // Native browser validations (e.g., required, minlength)
        if (!this.checkValidity()) {
            return; // Let the browser handle the HTML5 validation messages
        }

        e.preventDefault(); // Block actual submission until we verify everything

        const currentPass = $('#current_password').val();
        const newPass = $('#new_password').val();
        const confirmPass = $('#confirm_password').val();
        const form = this;

        let valid = true;

        // Clear previous error messages
        $('#currentPasswordStatus').hide();
        $('#passwordMatchStatus').hide();

        // Step 1: Check if new password and confirm password match
        if (newPass !== confirmPass) {
            $('#passwordMatchStatus')
                .text('New passwords do not match.')
                .css('color', 'red')
                .show();
            valid = false;
        }

        if (!valid) {
            return; // Prevent form submission if password mismatch
        }

        // Step 2: Verify current password via AJAX
        $.ajax({
            type: 'POST',
            url: 'verify_current_password.php',
            data: { current_password: currentPass },
            dataType: 'json',
            success: function (response) {
                if (!response.valid) {
                    $('#currentPasswordStatus')
                        .text('Current password is incorrect.')
                        .css('color', 'red')
                        .show();
                } else {
                    $('#currentPasswordStatus').hide(); // Clear error if previously shown
                    form.submit(); // Submit the form after all validations pass
                }
            },
            error: function () {
                $('#currentPasswordStatus')
                    .text('Server error while verifying password.')
                    .css('color', 'red')
                    .show();
            }
        });
    });
});
</script>

        </body>
    </html>
