<?php
session_start();
include_once '../model/stock_model.php';

$stock_model = new stock_model();

if (isset($_GET['action'])) {
    $action = $_GET['action'];
    $category_id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($category_id) {
        // Switch based on the action requested
        switch ($action) {
            case 'activate':
                activateCategory($category_id, $stock_model);
                break;

            case 'deactivate':
                deactivateCategory($category_id, $stock_model);
                break;

            case 'delete':
                deleteCategory($category_id, $stock_model);
                break;

            case 'edit':
                editCategory($category_id, $stock_model);
                break;

            default:
                // Redirect back or show an error message
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED!',
                    'message' => 'Undefined Action.'
                ];
                header('Location: ../product_attributes.php');
                break;
        }
    }
}

function editCategory($category_id, $stock_model){
    if (!isset($_GET['category_name']) || empty(trim($_GET['category_name']))) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Missing Name',
            'message' => 'Category name cannot be empty.'
        ];
        header('Location: ../product_attributes.php');
        exit();
    }

    $category_name = trim($_GET['category_name']);

    // Update the category
    $result = $stock_model->updateCategory($category_name, $category_id);

    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Category Updated',
            'message' => 'The category has been successfully updated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while updating the category.'
        ];
    }

    header('Location: ../product_attributes.php');
    exit();
}


function activateCategory($category_id, $stock_model) {
    // Call the activate method from stock_model
    $result = $stock_model->enableCategory($category_id, 1);

    // Provide feedback to the user
    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Category Activated',
            'message' => 'The category has been successfully activated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while activating the category.'
        ];
    }

    // Redirect back to the categories page
    header('Location: ../product_attributes.php');
    exit();
}

function deactivateCategory($category_id, $stock_model) {
    // Call the deactivate method from stock_model
    $result = $stock_model->disableCategory($category_id, 0);

    // Provide feedback to the user
    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'warning',
            'title' => 'Category Deactivated',
            'message' => 'The category has been successfully deactivated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while deactivating the category.'
        ];
    }

    // Redirect back to the categories page
    header('Location: ../product_attributes.php');
    exit();
}

function deleteCategory($category_id, $stock_model) {
    // Check if category is being used by active products
    $activeProducts = $stock_model->getActiveProductsByCategory($category_id);

    if (!empty($activeProducts)) {
        $_SESSION['notification'] = [
            'type' => 'warning',
            'title' => 'Cannot Delete Category',
            'message' => 'This category is associated with active products. Please reassign or deactivate those products first.'
        ];
        header('Location: ../product_attributes.php');
        exit();
    }

    // Proceed to delete if not in use
    $result = $stock_model->deleteCategory($category_id);

    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Category Deleted',
            'message' => 'The category has been successfully deleted.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while deleting the category.'
        ];
    }

    header('Location: ../product_attributes.php');
    exit();
}

?>
