<?php
    session_start();
    include '../model/employees_model.php'; 

    // Initialize model and perform further validation (e.g., check leave balance)
            $employees_model = new employees_model();

    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Check which form is submitted by a hidden input flag
        if (isset($_POST['leave_form']) && $_POST['leave_form'] === 'leave_form') {
            
            // Sanitize and validate inputs
            $employee_code = isset($_POST['employee_code']) ? trim($_POST['employee_code']) : '';
            $requested_start_date = isset($_POST['requested_start_date']) ? trim($_POST['requested_start_date']) : '';
            $requested_end_date = isset($_POST['requested_end_date']) ? trim($_POST['requested_end_date']) : '';
            $requested_num_days = isset($_POST['requested_num_days']) ? intval($_POST['requested_num_days']) : 0;
            $leave_id = isset($_POST['leave']) ? intval($_POST['leave']) : 0;

            

            if (!$employee_code || !$requested_start_date || !$requested_end_date || !$requested_num_days || !$leave_id) {
                
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Please fill all required fields correctly.'
                ];
                header("Location: ../leave_breakdown.php?employee={$employee_code}");
                exit;
            }

            // Optional: Validate date formats and logic (start <= end)
            $start = strtotime($requested_start_date);
            $end = strtotime($requested_end_date);

            if ($start === false || $end === false || $end < $start) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Please fill all required fields correctly.'
                ];
                header("Location: ../leave_breakdown.php?employee={$employee_code}");
                exit;
            }


            $leaveDetails = $employees_model->getleaveSummaryData($employee_code);

            $individualLeaveDetails = $employees_model->leaveDetails($leave_id);
            $leave_type = $individualLeaveDetails['leave_type'];
            $operator = $_SESSION['sess_employeecode'];
            $leave_state = 0;
            date_default_timezone_set('Africa/Blantyre');
            $datecaptured = date('Y-m-d H:i');

            if ($requested_num_days > $leaveDetails['total_left']) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'You do not have enough leave days remaining.'
                ];
                header("Location: ../leave_breakdown.php?employee_code={$employee_code}");
                exit;

                
            }

            // Proceed to save leave request to database (you'll need to implement saveLeaveRequest)
            $lastinsertID = $employees_model->saveLeaveRequest($leave_id, $leave_type, $employee_code, $requested_start_date, $requested_end_date, $requested_num_days, $datecaptured, $operator, $leave_state);

            if ($lastinsertID) {
                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'SUCCESS',
                    'message' => 'Leave application submitted successfully.'
                ];
                header("Location: ../leave_slip.php?id={$lastinsertID}");
                exit;
            } else {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Failed to submit leave application. Please try again.'
                ];
                header("Location: ../leave_breakdown.php?employee_code={$employee_code}");
                exit;
            }
        }elseif (isset($_POST['leave_form_everyone']) && $_POST['leave_form_everyone'] === 'leave_form_everyone') {
            
            // Sanitize and collect form inputs
            $employee_code = trim($_POST['employee_code'] ?? '');
            $requested_start_date = trim($_POST['requested_start_date'] ?? '');
            $requested_end_date = trim($_POST['requested_end_date'] ?? '');
            $requested_num_days = intval($_POST['requested_num_days'] ?? 0);
            $leave_id = intval($_POST['leave'] ?? 0);

            // Validate required fields
            if (!$employee_code || !$requested_start_date || !$requested_end_date || !$requested_num_days || !$leave_id) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Please fill all required fields correctly.'
                ];
                header("Location: ../leave_requests.php");
                exit;
            }

            // Validate date order
            if (strtotime($requested_start_date) > strtotime($requested_end_date)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Start date cannot be after end date.'
                ];
                header("Location: ../leave_requests.php");
                exit;
            }

            // Validate leave balance
            $leaveDetails = $employees_model->getleaveSummaryData($employee_code);
            if ($requested_num_days > $leaveDetails['total_left']) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Requested days exceed available leave balance.'
                ];
                header("Location: ../leave_requests.php");
                exit;
            }

            // Retrieve leave type
            $individualLeaveDetails = $employees_model->leaveDetails($leave_id);
            $leave_type = $individualLeaveDetails['leave_type'];

            // Operator info and other metadata
            $operator = $_SESSION['sess_employeecode'] ?? 'SYSTEM';
            $leave_state = 0;
            date_default_timezone_set('Africa/Blantyre');
            $datecaptured = date('Y-m-d H:i:s');

            // Save to database
            $lastinsertID = $employees_model->saveLeaveRequest(
                $leave_id,
                $leave_type,
                $employee_code,
                $requested_start_date,
                $requested_end_date,
                $requested_num_days,
                $datecaptured,
                $operator,
                $leave_state
            );

            if ($lastinsertID) {
                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'SUCCESS',
                    'message' => 'Leave application submitted successfully.'
                ];
                header("Location: ../leave_slip.php?id={$lastinsertID}");
                exit;
            } else {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'REQUEST FAILED',
                    'message' => 'Could not save leave application. Try again later.'
                ];
                header("Location: ../leave_requests.php");
                exit;
            }
        }else{
            $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'REQUEST FAILED',
            'message' => 'Invalid Request Type, Process the form with attached form.'
            ];
            header("Location: ../leave_requests.php");
            exit;     
        }


    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'REQUEST FAILED',
            'message' => 'Invalid Request Type, Process the form with attached form.'
            ];
        header("Location: ../leave_requests.php");
        exit;
    }
