<?php
session_start();
include_once '../model/common_model.php';

$common_model = new common_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['addLocation'])) {

        $id = $common_model->getMaxLocationId() + 1;
	    $code = "AC-Loc-".$id;


        $location_id = $code;
        $location_name = trim($_POST['location_name']);
        $district_id = $_POST['district'];
    
        // Insert into database
        $result = $common_model->addLocation($location_id, $location_name, $district_id);
    
        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'Successfully Saved Location'
            ];
            header("Location: ../manage_locations.php");
            exit;
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Save Failed',
                'message' => 'Failed To Add Location'
            ];
            header("Location: ../manage_locations.php");
            exit;
        }
    }

    if (isset($_POST['editLocation'])) {
        $location_id = $_POST['location_id'];
        $location_name = trim($_POST['location_name']);
        $district = trim($_POST['district']);
        $location_state = $_POST['location_state'];

        if (empty($location_id) || empty($location_name) || empty($district) || !isset($location_state)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Update Failed',
                'message' => 'Please fill in all required fields.'
            ];
            header("Location: ../manage_locations.php");
            exit();
        }

        $result = $common_model->updateLocation($location_id, $location_name, $district, $location_state);

        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Product Updated',
                'message' => 'Location has been updated successfully.'
            ];
            header("Location: ../manage_locations.php");
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Update Failed',
                'message' => 'There was an error while updating Location.'
            ];
            header("Location: ../manage_locations.php");
            exit();
        }
    }
    
} else {
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Save Failed',
        'message' => 'Unverified Server Request Method'
    ];
    header("Location: ../manage_locations.php");
    exit();
}
?>
