<?php
    session_start();

    date_default_timezone_set('Africa/Blantyre');
    $date_captured = date('Y-m-d H:i:s');

    file_put_contents("debug_log.txt", "Controller called\n", FILE_APPEND);


    require_once '../model/orders_model.php';
    require_once '../model/users_model.php';

    $orders_model = new orders_model();
    $users_model  = new users_model();

    // Handle actions via GET
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action'])) {
        $action = $_GET['action'];

        switch ($action) {
            case 'cancelinvoice':
                cancelInvoice($orders_model, $users_model, $date_captured);
                break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Unknown Action',
                    'message' => 'The requested action is not recognized.'
                ];
                header('Location: ../all_invoices.php');
                exit();
        }
    }else{
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'SERVER REQUEST',
            'message' => 'Unverified Action Request.'
        ];
        header('Location: ../all_invoices.php');
        exit();
    }

    function cancelInvoice($orders_model, $users_model, $date_captured){
        $invoiceNumber = isset($_GET['invoice_number']) ? trim($_GET['invoice_number']) : '';
        $orderState    = isset($_GET['order_state']) ? intval($_GET['order_state']) : 3;
        $reason        = isset($_GET['reason']) ? trim($_GET['reason']) : '';
        $userId        = $_SESSION['sess_employeecode'] ?? 0;
        

        if (empty($invoiceNumber) || empty($reason) || empty($orderState) || $userId === 0) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'Invoice number, reason, and user must be provided.'
            ];
            header('Location: ../all_invoices.php');
            exit();
        }

        if (empty($userId) || !$users_model->isValidUser($userId)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Unauthorized',
                'message' => 'Access denied. Invalid user session.'
            ];
            header('location:../../index.php');
            exit();
        }

        file_put_contents("debug_log.txt", "Calling cancelInvoiceAndRestoreStock() for $invoiceNumber\n", FILE_APPEND);

        $cancelSuccess = $orders_model->cancelInvoiceAndRestoreStock($invoiceNumber, $orderState, $reason, $date_captured);

        if ($cancelSuccess) {
            // Step 2: Log the cancellation separately
            $logSuccess = $orders_model->logInvoiceCancellation($invoiceNumber, $userId, $reason, $date_captured);

            if ($logSuccess) {
                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'Invoice Cancelled',
                    'message' => "Invoice <strong>$invoiceNumber</strong> has been cancelled and logged."
                ];
                header("Location: ../invoice.php?invoice_number=$invoiceNumber");
                exit();
            } else {
                $_SESSION['notification'] = [
                    'type' => 'warning',
                    'title' => 'Cancelled, Not Logged',
                    'message' => 'Invoice was cancelled, but reason could not be logged.'
                ];
                header("Location: ../invoice.php?invoice_number=$invoiceNumber");
                exit();
            }

        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Cancellation Failed',
                'message' => 'Failed to cancel invoice. Stock or state update failed.'
            ];
            header('Location: ../all_invoices.php');
            exit();
        }
    }

