<?php
    session_start();
    include_once '../model/setup_model.php';

    $setup_model = new setup_model();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $action = $_POST['action'] ?? '';

        switch ($action) {

            case 'change_setting':
                changeSetting($setup_model);
                break;

            case 'update_vat':
                updateVat($setup_model);
                break;

            case 'update_display_setting':
                updateDisplaySettings($setup_model);
                break;


            case 'mark_as_read':
                MarkAsRead($setup_model);
                break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Setup Failed',
                    'message' => 'Unrecognised action requested.'
                ];
                header("Location: ../dashboard.php");
                exit();
        }
    }

    function updateDisplaySettings($setup_model){
        $column = $_POST['column'];
        $value  = (int) $_POST['value'];
        $username = $_SESSION['sess_username'];

        // whitelist allowed columns (VERY important)
        $allowedColumns = [
            'sales_display',
            'payments_display'
        ];

        if (!in_array($column, $allowedColumns)) {
            echo json_encode(['success' => false, 'message' => 'Invalid column']);
            exit;
        }

        $setup_model->updateDisplaySettings($username, $column, $value);

        echo json_encode(['success' => true]);
        exit;
    }

    function MarkAsRead($setup_model){
        $id = $_POST['notification_id'];
        $action = $setup_model->markAsRead($id);
    }


    function updateVat($setup_model){
    $vat_entered = isset($_POST['vat']) ? floatval($_POST['vat']) : null;
    $vat = $vat_entered/100;
    // Validation
    if ($vat === null || $vat < 0 || $vat > 100) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Invalid VAT',
            'message' => 'VAT must be between 0 and 100.'
        ];
        header("Location: ../setup_tools.php");
        exit();
    }

    if ($setup_model->updateVat($vat)) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'VAT Updated',
            'message' => 'VAT value updated successfully.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Update Failed',
            'message' => 'Failed to update VAT value.'
        ];
    }

    header("Location: ../setup_tools.php");
    exit();
}

    function changeSetting($setup_model){
        $setting_key = $_POST['setting_key'] ?? '';
        $value = isset($_POST['value']) ? (int) $_POST['value'] : 0;

        if ($setup_model->updateSetting($setting_key, $value)) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => ucfirst($setting_key) . ' setting updated successfully.'
            ];
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Update failed',
                'message' => 'Failed to update setting.'
            ];
        }
        header("Location: ../setup_tools.php");
        exit;
    }
