<?php
session_start();
include_once '../model/stock_model.php';

$stock_model = new stock_model();

if (isset($_GET['action'])) {
    $action = $_GET['action'];
    $unit_id = isset($_GET['id']) ? $_GET['id'] : null;

    if ($unit_id) {
        // Switch based on the action requested
        switch ($action) {
            case 'activate':
                activateUnit($unit_id, $stock_model);
                break;

            case 'deactivate':
                deactivateUnit($unit_id, $stock_model);
                break;

            case 'delete':
                deleteUnit($unit_id, $stock_model);
                break;

            case 'edit':
                editUnit($unit_id, $stock_model);
                break;

            default:
                // Redirect back or show an error message
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED!',
                    'message' => 'Undefined Action.'
                ];
                header('Location: ../product_attributes.php');
                break;
        }
    }
}

function editUnit($unit_id, $stock_model){
    if (!isset($_GET['unit_name']) || empty(trim($_GET['unit_name']))) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Missing Name',
            'message' => 'Unit name cannot be empty.'
        ];
        header('Location: ../product_attributes.php');
        exit();
    }

    $unit_name = trim($_GET['unit_name']);

    // Update the category
    $result = $stock_model->updateUnit($unit_name, $unit_id);

    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => 'Unit has been successfully updated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while updating the unit.'
        ];
    }

    header('Location: ../product_attributes.php');
    exit();
}


function activateUnit($unit_id, $stock_model) {
    // Call the activate method from stock_model
    $result = $stock_model->enableUnit($unit_id, 1);

    // Provide feedback to the user
    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Category Activated',
            'message' => 'The category has been successfully activated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while activating the category.'
        ];
    }

    // Redirect back to the categories page
    header('Location: ../product_attributes.php');
    exit();
}

function deactivateUnit($unit_id, $stock_model) {
    // Call the deactivate method from stock_model
    $result = $stock_model->disableUnit($unit_id, 0);

    // Provide feedback to the user
    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'warning',
            'title' => 'Category Deactivated',
            'message' => 'The category has been successfully deactivated.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while deactivating the category.'
        ];
    }

    // Redirect back to the categories page
    header('Location: ../product_attributes.php');
    exit();
}

function deleteUnit($unit_id, $stock_model) {
    // Check if category is being used by active products
    $activeProducts = $stock_model->getActiveProductsByUnit($unit_id);

    if (!empty($activeProducts)) {
        $_SESSION['notification'] = [
            'type' => 'warning',
            'title' => 'Cannot Delete Category',
            'message' => 'This category is associated with active products. Please reassign or deactivate those products first.'
        ];
        header('Location: ../product_attributes.php');
        exit();
    }

    // Proceed to delete if not in use
    $result = $stock_model->deleteUnit($unit_id);

    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Category Deleted',
            'message' => 'The category has been successfully deleted.'
        ];
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'An error occurred while deleting the category.'
        ];
    }

    header('Location: ../product_attributes.php');
    exit();
}

?>
