<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
      </head>

      <body class="nav-md">
        <div class="container body">
          <div class="main_container">
            
            <?php
              include 'menu_finance.php';
              include_once 'model/sales_model.php';

              $sales_model = new sales_model();

              if (isset($_GET['state']) && $_GET['state'] !== '') {

                  $state = intval($_GET['state']);
                  $delivery_notes = $sales_model->getDeliveryNotes($state);

              } else {

                  // NULL = return all
                  $delivery_notes = $sales_model->getDeliveryNotes();

              }

              
              
              

            ?>
            <!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3><small>Delivery Notes  </small></h3>
              </div>

              <div class="title_right">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              

              

              <div class="col-md-12 col-sm-12 ">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Manage Delivery Notes</h2>
                    <ul class="nav navbar-right panel_toolbox">
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                      <div class="row">
                          <div class="col-sm-12">
                            <div class="card-box table-responsive">
                    
                    <table id="dn_notes-table" class="table table-striped table-bordered" style="width:100%">
                      <thead>
                        <tr>
                          <th>Reference</th>
                          <th>Date</th>
                          <th>Location</th>
                          <th>Customer</th>
                          <th style="text-align: center;">Reference</th>
                          <th style="text-align: center;">Number of Products</th>
                          <th style="text-align: center;">Total Number of Items</th>
                          <th style="text-align: center;">Status</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                            foreach($delivery_notes as $data):
                        ?>
                          <tr>
                            <td><?php echo $data['dn_number']?></td>
                            <td><?php echo $data['dn_date']?></td>
                            <td><?php echo $data['location']?></td>
                            <td><?php echo $data['customer_name']?></td>
                            <td><?php echo $data['reference']?></td>
                            <td style="text-align: center;"><?php echo $data['number_of_products']?></td>
                            <td style="text-align: center;"><?php echo $data['total_items']?></td>
                            <td style="text-align:center;">
                              <?php
                                  switch ($data['dn_state']) {
                                      case 0:
                                          $class = "label label-danger";   // Cancelled
                                          break;
                                      case 1:
                                          $class = "label label-warning";  // Pending
                                          break;
                                      case 2:
                                          $class = "label label-success";  // Invoiced
                                          break;
                                      case 3:
                                          $class = "label label-info";     // Cancel Requested
                                          break;
                                      default:
                                          $class = "label label-default";
                                  }
                              ?>
                              <span class="<?= $class ?>">
                                  <?= $data['dn_status'] ?>
                              </span>
                            </td>

                            <td style="text-align: center; white-space: nowrap;">

                              <!-- 1️⃣ Open Delivery Note -->
                              <a href="customer_delivery_note.php?dn_number=<?= urlencode($data['dn_number']) ?>" class="btn btn-info btn-sm" title="View Delivery Note">
                                <i class="fas fa-file-invoice"></i>
                              </a>

                              <!-- 2️⃣ Send WhatsApp -->
                              <button 
                                class="btn btn-success btn-sm send-doc"
                                data-channel="whatsapp"
                                data-doc-type="<?= ($data['sale_type']=='customer_delivery_note') ? 'customer_delivery_note' : 'invoice' ?>"
                                data-reference="<?= $data['dn_number'] ?>"
                                data-dn-state="<?= $data['dn_state'] ?>"
                                title="Send via WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </button>

                              <!-- 3️⃣ Send Email -->
                              <button 
                                class="btn btn-primary btn-sm send-doc"
                                data-channel="email"
                                data-doc-type="<?= ($data['sale_type']=='customer_delivery_note') ? 'customer_delivery_note' : 'invoice' ?>"
                                data-reference="<?= $data['dn_number'] ?>"
                                data-dn-state="<?= $data['dn_state'] ?>"
                                title="Send via Email">
                                <i class="fas fa-envelope"></i>
                            </button>

                            <button class="btn btn-info btn-sm feature-not-ready">
                                <i class="fa fa-cog"></i>
                            </button>

                          </td>


                          </tr>
                        <?php
                            endforeach;
                        ?>
                        
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
                </div>
              </div>

              

              
            </div>
          </div>
        </div>
        <!-- /page content -->
          </div>
          <!-- /page content -->

        <?php
          include_once 'footer.php';
        ?>
      </div>
    </div>

    <?php
      include_once 'libraries.php';
    ?>
    <script>
            function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
          }
        </script>
    <script>
      $(document).ready(function () {
          let table = $('#dn_notes-table').DataTable({
              responsive: true,
              ordering: true,
              pageLength: 50,
              columnDefs: [
                  {
                      targets: -1, // Assuming "Action" is the last column; use correct index if different
                      width: "150px",
                      className: "text-center",
                      orderable: false // Usually actions shouldn't affect sorting
                  }
              ]
          });

          // Search across all columns using external input
          $('#search_query').on('keyup', function () {
              table.search(this.value).draw();
          });
      });
  </script>
    
	
  </body>
</html>
