<?php
include_once 'model/sales_model.php';
$sales_model = new sales_model();

$sales_number = $_POST['sales_number'] ?? '';

if (!empty($sales_number)) {
    $items = $sales_model->getReceiptItems($sales_number);

    if ($items) {
        $grandTotal = 0;
        ob_start(); // Buffer output
        ?>
        <table class="table table-bordered table-striped">
            <thead class="bg-info text-white">
                <tr>
                    <th>Item</th>
                    <th style="text-align:center;">Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): 
                    $grandTotal += $item['total']; ?>
                    <tr>
                        <td><?= htmlspecialchars($item['product_name']) ?></td>
                        <td style="text-align:center;"><?= $item['quantity'] ?></td>
                        <td>MK <?= number_format($item['selling_price'], 2) ?></td>
                        <td>MK <?= number_format($item['total'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3" style="text-align:right;">Grand Total</th>
                    <th style="font-weight:bold; color:#d9534f;">MK <?= number_format($grandTotal, 2) ?></th>
                </tr>
            </tfoot>
        </table>
        <?php
        echo ob_get_clean();
    } else {
        echo "<p class='text-muted text-center mt-3'>No items found for this transaction.</p>";
    }
} else {
    echo "<div class='alert alert-warning text-center mt-3'>Invalid sales number.</div>";
}
