<?php
include_once 'model/stock_model.php';
$stock_model = new stock_model();

$type = $_POST['type'] ?? null;
$id = $_POST['id'] ?? null;

if (!$type || !$id) {
    exit('<p class="text-danger">Invalid selection.</p>');
}

    // Fetch products NOT linked to selected warehouse or branch
    $unlinked = $stock_model->getUnlinkedProducts($type, $id);


    if ($unlinked && count($unlinked) > 0) {
        echo "<form method='POST' action='attach_selected_products.php'>";
        echo "<input type='hidden' name='type' value='" . htmlspecialchars($type) . "'>";
        echo "<input type='hidden' name='id' value='" . htmlspecialchars($id) . "'>";
        echo "<table class='table table-bordered'>
                <thead>
                    <tr>
                        <th>
                            <input type='checkbox' id='selectAllProducts'>
                        </th>
                        <th>Product Name</th>
                        <th>Category</th>
                        <th>Unit</th>
                        <th>Code</th>
                        <th>Opening Stock</th>
                        <th>Minimum Stock Level</th>
                    </tr>
                </thead>

                <tbody>";
                    foreach ($unlinked as $product) {
                        $pid = htmlspecialchars($product['product_id']);
                        echo "<tr>
                                <td><input type='checkbox' class='product-checkbox' data-id='{$pid}' name='product_ids[]' value='{$pid}'></td>
                                <td>{$product['product_name']}</td>
                                <td>{$product['categoryname']}</td>
                                <td>{$product['unitname']}</td>
                                <td>{$product['product_code']}</td>
                                <td>
                                    <input type='number' name='opening_stock[{$pid}]' class='form-control stock-{$pid}' min='0' placeholder='Enter Product Opening Stock'>
                                </td>
                                <td>
                                    <input type='number' name='min_stock[{$pid}]' class='form-control stock-{$pid}' min='3' placeholder='Enter Product Minimum Stock Level'>
                                </td>
                            </tr>";
                    }


            echo "
                </tbody>
            </table>
            <button class='btn btn-success' type='submit'>Attach Selected</button></form>";
    } else {
        echo "<p>No products available to attach.</p>";
    }

    echo "
    </form>
    <script>
        $(document).ready(function () {
            $('.product-checkbox').on('change', function () {
                const id = $(this).data('id');
                const stockInputs = $('.stock-' + id);
                if ($(this).is(':checked')) {
                    stockInputs.attr('required', true);
                } else {
                    stockInputs.removeAttr('required');
                }
            });
        });
    </script>

    <script>
    $(document).ready(function () {
        // Handle individual checkbox input requirements
        $('.product-checkbox').on('change', function () {
            const id = $(this).data('id');
            const stockInputs = $('.stock-' + id);
            if ($(this).is(':checked')) {
                stockInputs.attr('required', true);
            } else {
                stockInputs.removeAttr('required');
            }
        });

        // Handle Select All
        $('#selectAllProducts').on('change', function () {
            const isChecked = $(this).is(':checked');
            $('.product-checkbox').prop('checked', isChecked).trigger('change');
        });
    });
</script>
";


    


