    <?php
    include_once 'model/companies_model.php';
    include_once 'model/setup_model.php';

    $companies_model = new companies_model();
    $setup_model = new setup_model();

    $isProcurementEnabled = $setup_model->checkProcurement('procurement'); // returns 1 or 0


    $id = $_POST['id'] ?? null;

    if (!$id) {
        exit('<p class="text-danger">Invalid selection.</p>');
    }

        // Fetch products NOT linked to selected warehouse or branch
        $unlinked = $companies_model->getUnlinkedProducts($id);


        if ($unlinked && count($unlinked) > 0) {
            echo "<form method='POST' action='attach_third_party_selected_products.php'>";
            echo "<input type='hidden' name='company_id' value='" . htmlspecialchars($id) . "'>";
            echo "<table class='table table-bordered'>
                    <thead>
                        <tr>
                            <th><input type='checkbox' id='selectAllProducts'></th>
                            <th>Product Name</th>
                            <th>Category</th>
                            <th>Unit</th>
                            <th>Code</th>
                            <th>Opening Stock</th>
                            <th>Minimum Stock Level</th>";
                            
                            if ($isProcurementEnabled) {
                                echo "<th>Order Price (MK)</th>";
                            }

                            echo 
                        "</tr>
                    </thead>
                    <tbody>";

                        foreach ($unlinked as $product) {
                            $pid = htmlspecialchars($product['product_id']);
                            echo "<tr>
                                    <td><input type='checkbox' class='product-checkbox' data-id='{$pid}' name='product_ids[]' value='{$pid}'></td>
                                    <td>{$product['product_name']}</td>
                                    <td>{$product['categoryname']}</td>
                                    <td>{$product['unitname']}</td>
                                    <td>{$product['product_code']}</td>
                                    <td>
                                        <input type='number' name='opening_stock[{$pid}]' class='form-control stock-{$pid}' min='0' placeholder='Enter Product Opening Stock'>
                                    </td>
                                    <td>
                                            <input type='number' name='min_stock[{$pid}]' class='form-control stock-{$pid}' min='10' placeholder='Enter Product Minimum Stock Level'>
                                    </td>";

                                    if($isProcurementEnabled){
                                        echo "<td>
                                        <input type='number' name='order_price[{$pid}]' class='form-control stock-{$pid}' step='0.01' min='1000' placeholder='Enter Order Price (MK)'>
                                    </td>";
                                    }
                                echo "</tr>";
                        }


                echo "
                    </tbody>
                </table>
                <button class='btn btn-success' type='submit'>Attach Selected</button></form>";
        } else {
            echo "<p>No products available to attach.</p>";
        }

        echo "
        </form>
        <script>
            $(document).ready(function () {
                // Handle individual checkbox input requirements
                $('.product-checkbox').on('change', function () {
                    const id = $(this).data('id');
                    const stockInputs = $('.stock-' + id);
                    if ($(this).is(':checked')) {
                        stockInputs.attr('required', true);
                    } else {
                        stockInputs.removeAttr('required');
                    }
                });

                // Handle Select All
                $('#selectAllProducts').on('change', function () {
                    const isChecked = $(this).is(':checked');
                    $('.product-checkbox').prop('checked', isChecked).trigger('change');
                });
            });
        </script>
    ";


        


