<?php

include_once 'config.php';

class expenses_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getExpenses()
    {
        $query = "SELECT *,
                COALESCE(emp.fullname, 'Default User') AS operator_name

            FROM 
                recorded_expenses re
            LEFT JOIN 
                employees emp ON re.operator = emp.employee_code
            ORDER BY 
                expense_date DESC";
        $smtp = $this->link->prepare($query);

        $smtp->execute();
        $expenses = $smtp->fetchAll(PDO::FETCH_ASSOC);
        return $expenses;
    }
    
}