<?php
	session_start();
	include 'model/common_model.php';
	include 'model/employees_model.php';
	
?>
<html>
	<head>
		<title>Branches</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
			.select2 {
            	font-size: 18px;   /* Adjust font size */
            	height: 40px; 
            }     /* Optional: height */
			.select2 {
				display: block;
				width: 100%;
				height: calc(1.5em + .75rem + 2px);
				font-size: 1rem;
				font-weight: 400;
				background-color: #fff;
				background-clip: padding-box;
				border-radius: .25rem;
				transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;

			}

			.select2{
				width: 320px !important;  /* Adjust width */
			}
			/* Align selected option text and set font color */
			.select2-selection__rendered {
				text-align: left !important;
				color: #495057 !important;
			}

			/* Align dropdown items text and set font color */
			.select2-results__option {
				text-align: left !important;
				color: #495057 !important;
			}
		</style>
	</head>
	<body>
		<?php

			$common_model = new common_model();
			$employees_model = new employees_model();

			$companyDetails = $common_model->getCompanyDetails();
			$district = $companyDetails['district'];
			$locations = $common_model->getAllLocations($district);

		?>

		<form action="save_branch.php" method="post">

				<center>
				<h2 class="page_titles">ADD Branch <i class="fa fa-mug-hot"></i></h2>
					<hr>
					
					<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="warehousename" name="name_branch" class="form-control" required placeholder="Enter Name To Identify Branch">
					<span id="Error" style="color: red;"></span><br>

					<select name="location" class="select2" style="width: 280px; height:40px;" required>
						<option value="" selected disabled>Select Location</option>
						<?php 
							foreach($locations as $location):
						?>
							<option value="<?php echo $location['loc_id']?>"><?php echo $location['location_name']?></option>
						<?php
							endforeach;
						?>
					</select>
					<br>

						<input type="text" name="branch_code" class="form-control" placeholder="Enter Branch Code" style="width: 320px; height:40px;" id="branch_code" required>
						<span style="display: none;" id="branch_code_Error"></span>
						<br>
					
					
					<br>
					<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">SAVE BRANCH <i class="fa fa-save"></i></button>
				</center>
			
		</form>
		<script>
				$(function () {
					$('.select2').select2()
				});
			</script>
		<script>
        function checkCategory() {
            const categoryname = $('input[name="categoryname"]').val();
            	$.post('check_category.php', { categoryname: categoryname }, function(data) {
                	if (data.exists) {
                    	$('#Error').text('Category name already exists');
                    	$('#SaveButton').prop('disabled', true);
                	} else {
                    	$('#Error').text('');
                    	$('#SaveButton').prop('disabled', false);
                	}
            	}, 'json');
        	}
        
			$(document).ready(function() {
				$('input[name="categoryname"]').on('input', checkCategory);		
			});

			
			$(document).ready(function() {
				$('#branch_code').on('input', function() {
					const code = $(this).val().trim();

					if (code === '') {
						$('#branch_code_Error').hide();
						$('#SaveButton').prop('disabled', false);
						return;
					}

					$.post('check_branch_code.php', { branch_code: code }, function(data) {
						if (data.exists) {
							$('#branch_code_Error').text('Branch code already exists').css('color', 'red').show();
							$('#SaveButton').prop('disabled', true);
						} else {
							$('#branch_code_Error').hide();
							$('#SaveButton').prop('disabled', false);
						}
					}, 'json');
				});
			});

    	</script>
		
	</body>
</html>