<?php
	session_start();
	include_once 'model/employees_model.php';
	
	
?>
<html>
	<head>
		<title>Warehouse</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$employees_model = new employees_model();
			$departments = $employees_model->getDepartments();
		?>
		
			<form action="save_post.php" method="post">
			
				<center>
					<h2 class="page_titles">ADD POST <i class="fa fa-mug-hot"></i></h2>
					<hr>
					
					<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="postname" name="post_name" class="form-control" required placeholder="Enter Name/Title of Post ">
					<span id="Error" style="color: red;"></span><br>

					<input type="number" name="gross_salary" style="width: 320px; height:40px;" class="form-control" placeholder="Enter Gross Salary for the post" required>
					<br>
					
					<input type="number" name="overtime_rate" style="width: 320px; height:40px;" class="form-control" placeholder="Overtime Rate" required>
					<br>

					<select name="department" class="form-control" style="width: 320px; height:40px;" required>
						<option value="" selected disabled>Select Department</option>
						<?php
							foreach($departments as $department):
						?>
							<option value="<?php echo $department['id']?>"><?php echo $department['department_name']?></option>
						<?php
							endforeach;
						?>
					</select>
					<br>

					
					
					<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:320px;font-size: 18px;">SAVE POST <i class="fa fa-save"></i></button>
				</center>
			
			</form>
		<script>
        function checkpost() {
            const postname = $('input[name="post_name"]').val();
            	$.post('check_post.php', { postname: postname }, function(data) {
                	if (data.exists) {
                    	$('#Error').text('Post name already exists');
                    	$('#SaveButton').prop('disabled', true);
                	} else {
                    	$('#Error').text('');
                    	$('#SaveButton').prop('disabled', false);
                	}
            	}, 'json');
        	}
        
			$(document).ready(function() {
				$('input[name="post_name"]').on('input', checkpost);		
			});
    	</script>
	</body>
</html>