<?php
	session_start();
	include 'model/users_model.php';
    include_once 'model/employees_model.php';
	include_once 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Users</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}

             /* Set font size and width for Select2 */
			.select2 {
				font-size: 18px;   /* Adjust font size */
				height: 40px; 
				}     /* Optional: height */
			.select2 {
				display: block;
				width: 100%;
				height: calc(1.5em + .75rem + 2px);
				font-size: 1rem;
				font-weight: 400;
				background-color: #fff;
				background-clip: padding-box;
				border-radius: .25rem;
				transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;

			}

			.select2{
				width: 320px !important;  /* Adjust width */
			}
			/* Align selected option text and set font color */
			.select2-selection__rendered {
				text-align: left !important;
				color: #495057 !important;
			}

			/* Align dropdown items text and set font color */
			.select2-results__option {
				text-align: left !important;
				color: #495057 !important;
			}
		</style>
	</head>
	<body>
		<?php
			$users_model = new users_model();
            $employees_model = new employees_model();
			$common_model = new common_model();

            $active_employees = $employees_model->getActiveEmployees();
			$locations = $common_model->getWarehousesBranches();

            
		?>
		
		<form action="controllers/users_controller.php" method="post">
			<center>
				<h2 class="page_titles">ADD SYSTEM USER <i class="fa fa-mug-hot"></i></h2>
				<hr>
					
				<select name="system_role" id="system_role" class="form-control" style="height: 45px;width:320px;margin-top: 5px" required>
					<option value="" selected disabled>Select System Role</option>
					<option value="Administrator">Chief Administrator</option>
					<option value="Cashier">Cashier</option>
					<option value="Supervisor">Supervisor</option>
				</select>
                <br>

				<div id="location-wrapper" style="display: none;">
					<select name="location" id="location" class="select2" style="height: 40px; width: 320px;">
						<option value="" selected disabled>Select Location</option>
						<?php
							foreach($locations as $location):
						?>
						<option value="<?php echo $location['location_id']?>"><?php echo $location['name']?>(<?= $location['type'] ?>)</option>
						<?php
							endforeach;
						?>
					</select>
					<br>
				</div>
				
				<select id="employee_code" name="employee_code" class="form-control" style="height: 40px;width:320px;" required>
					<option value="" selected disabled>Select Employee</option>
					<?php foreach ($active_employees as $row): ?>
						<option 
							value="<?php echo $row['employee_code']; ?>"
							data-phone="<?php echo $row['phone_number']; ?>"
							data-email="<?php echo $row['email_address']; ?>"
						>
							<?php echo $row['fullname']; ?>
						</option>
					<?php endforeach; ?>
				</select>

				<br>
				<input type="text" id="phone" class="form-control" style="height: 40px;width:320px;margin-top: 5px" name="phone_number" readonly placeholder="Select Employee">
				<br>
				<input type="text" id="email" class="form-control" style="height: 40px;width:320px;margin-top: 5px" name="email" readonly placeholder="Select Employee">
				<br>

				

				<input type="text" style="height: 40px;width:320px;margin-top: 5px" placeholder="Enter Preferred Username" class="form-control" required name="username" id="username">

				<div id="warning-special" style="color:red;font-size:0.9em;margin-top:3px;display:none;">
					No spaces or special characters allowed.
				</div>

				<div id="warning-minlength" style="color:red;font-size:0.9em;margin-top:3px;display:none;">
					Minimum characters allowed is 5.
				</div>

				<div id="warning-exists" style="color:red;font-size:0.9em;margin-top:3px;display:none;">
					Username already exists. Please choose another.
				</div>

				
				<input type="hidden" name="action" value="add_new_user" readonly>
                <br>
				<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">ADD SYSTEM USER <i class="fa fa-save"></i></button>
			</center>
			
		</form>
        <script>
	        $(function () {
		    	$('.select2').select2()
			});
		</script>
		<script>
			document.getElementById('system_role').addEventListener('change', function () {
				const role = this.value;
				const locationWrapper = document.getElementById('location-wrapper');
				const locationField = document.getElementById('location');

				if (role === 'Cashier' || role === 'Supervisor') {
					locationWrapper.style.display = 'block';
					locationField.setAttribute('required', 'required');
				} else {
					locationWrapper.style.display = 'none';
					locationField.removeAttribute('required');
					locationField.value = ''; // reset selection
				}
			});
		
			document.getElementById('employee_code').addEventListener('change', function () {
				var selectedOption = this.options[this.selectedIndex];
				var phone = selectedOption.getAttribute('data-phone');
				var email = selectedOption.getAttribute('data-email');

				document.getElementById('phone').value = phone || '';
				document.getElementById('email').value = email || '';
			});

			const usernameInput = document.getElementById('username');
			const warningSpecial = document.getElementById('warning-special');
			const warningMinLength = document.getElementById('warning-minlength');
			const saveBtn = document.getElementById('SaveButton');

			// Input validation while typing
			usernameInput.addEventListener('input', () => {
				const val = usernameInput.value;
				const validPattern = /^[a-zA-Z0-9]*$/;

				// If input has special characters or spaces
				if (!validPattern.test(val)) {
					warningSpecial.style.display = 'block';
					warningMinLength.style.display = 'none';
					saveBtn.disabled = true;
				} else {
					warningSpecial.style.display = 'none';
					saveBtn.disabled = false;
					// Don't show minlength warning while typing
					warningMinLength.style.display = 'none';
				}
			});

			// On submit button click
			saveBtn.addEventListener('click', (e) => {
				const val = usernameInput.value;
				const validPattern = /^[a-zA-Z0-9]*$/;

				// Block if input has invalid characters (just in case)
				if (!validPattern.test(val)) {
					e.preventDefault();
					warningSpecial.style.display = 'block';
					warningMinLength.style.display = 'none';
					saveBtn.disabled = true;
					usernameInput.focus();
					return;
				}

				// Block if input is valid but too short
				if (val.length < 5) {
					e.preventDefault();
					warningMinLength.style.display = 'block';
					warningSpecial.style.display = 'none';
					usernameInput.focus();
					return;
				}

				// If valid
				warningSpecial.style.display = 'none';
				warningMinLength.style.display = 'none';
			});
		</script>
		<script>
			$(document).ready(function () {

				let typingTimer;
				const typingDelay = 500; // ms

				$('#username').on('keyup', function () {
					clearTimeout(typingTimer);

					let username = $(this).val().trim();

					typingTimer = setTimeout(function () {
						checkUsername(username);
					}, typingDelay);
				});

				function checkUsername(username) {
					$.ajax({
						url: 'controllers/users_controller.php',
						type: 'POST',
						data: {
							action: 'check_username',
							username: username
						},
						success: function (response) {
							let res = JSON.parse(response);

							if (res.exists) {
								$('#warning-exists').show();
							} else {
								$('#warning-exists').hide();
							}
						}
					});
				}

			});
			</script>


	</body>
</html>