    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Personal Info</title>
        <?php include_once 'css_links.php'; ?>
    </head>

    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php 
                    include 'menu_finance.php'; 
                    include_once 'model/employees_model.php';  

                    $employees_model = new employees_model();
                    $employees_data = $employees_model->getEmployeeDetails($emp_code);

                    $leave_data = $employees_model->getleaveSummaryData($emp_code);
                    $is_supervisor = $employees_model->isWarehouseSupervisor($emp_code);
                    $is_cashier = $employees_model->isBranchManager($emp_code);

                    $branch_name = '';
                    $warehouse_name = '';

                    if ($is_cashier) {
                        $branch_name = $employees_model->getBranchNameByEmpCode($emp_code);
                    }

                    if ($is_supervisor) {
                        $warehouse_name = $employees_model->getWarehouseNameByEmpCode($emp_code);
                    }

                    $default_codes = ['2000', '2001', '2002', '2003'];

                    
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            
                        </div>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 ">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Details</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Employees Personal Details</h5>
                                        </div>

                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>
                                    
                                    <div class="x_content">
                                        <div class="row">
                                            <?php if (!in_array($emp_code, $default_codes)): ?>
                                            <!-- Left Column: Personal Information -->
                                            <div class="col-md-8">
                                                <div class="card">
                                                    <div class="card-header bg-primary text-white">
                                                        <strong>Employee Profile</strong>
                                                    </div>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <!-- Profile Photo + Basic Summary -->
                                                            <div class="col-md-4 text-center">
                                                                <?php
                                                                    $picture = !empty($employees_data['picture']) ? htmlspecialchars($employees_data['picture']) : 'default_avatar.png';
                                                                    $imagePath = "images/employees/" . $picture;
                                                                ?>
                                                                <img src="<?= $imagePath ?>" 
                                                                    alt="Employee Photo" 
                                                                    class="img-fluid rounded mb-3" 
                                                                    style="width: 100%; max-height: 320px; object-fit: cover; border: 1px solid #ccc; padding: 5px;"
                                                                    onerror="this.onerror=null; this.src='images/default_avatar.png';">

                                                                <h3 class="mb-0"><?= htmlspecialchars($employees_data['fullname']) ?></h3>
                                                                <h5 class="text-info"><?= htmlspecialchars($employees_data['postname']) ?></h5>
                                                            </div>


                                                            <!-- Detailed Profile Info in Grid -->
                                                            <div class="col-md-8">
                                                                <div class="card border-0 shadow-sm">
                                                                    <div class="card-header bg-light text-dark">
                                                                        <strong>Basic Details</strong>
                                                                    </div>
                                                                    <div class="card-body" style="font-size: 1rem;">
                                                                        <dl class="row mb-0">
                                                                            <dt class="col-md-4 text-muted">Full Name</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars($employees_data['fullname']) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Post</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars($employees_data['postname']) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Phone</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars(preg_replace('/^0/', '+265', $employees_data['phone_number'])) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Email</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars($employees_data['email_address']) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Gender</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars($employees_data['gender']) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Date of Birth</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars(date('d M Y', strtotime($employees_data['date_of_birth']))) ?></dd>

                                                                            <dt class="col-md-4 text-muted">Nationality</dt>
                                                                            <dd class="col-md-8"><?= htmlspecialchars($employees_data['nationality']) ?></dd>
                                                                        </dl>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <!-- Structured Employee Info Display -->
                                                        <div class="row mt-4">
                                                            <div class="col-md-12">
                                                                <div class="card border-0 shadow-sm">
                                                                    <div class="card-header bg-light text-dark">
                                                                        <strong>Employee Information</strong>
                                                                    </div>
                                                                    <div class="card-body" style="font-size: 1rem;">
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Full Name</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['fullname']) ?></div>
                                                                            <div class="col-md-3 text-muted">Gender</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['gender']) ?></div>
                                                                        </div>
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Date of Birth</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars(date('d M Y', strtotime($employees_data['date_of_birth']))) ?></div>
                                                                            <div class="col-md-3 text-muted">Nationality</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['nationality']) ?></div>
                                                                        </div>
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Phone</div>
                                                                            <div class="col-md-3">
                                                                                <?= htmlspecialchars(preg_replace('/^0/', '+265', $employees_data['phone_number'])) ?>
                                                                            </div>

                                                                            <div class="col-md-3 text-muted">Email</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['email_address']) ?></div>
                                                                        </div>
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Current Location</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['location_name']) ?></div>
                                                                            <div class="col-md-3 text-muted">Home District</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['district_name']) ?></div>
                                                                        </div>
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Home Village</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['home_village']) ?></div>
                                                                            <div class="col-md-3 text-muted">Post</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['postname']) ?></div>
                                                                        </div>
                                                                        <div class="row mb-3">
                                                                            <div class="col-md-3 text-muted">Start Date</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars(date('d M Y',strtotime($employees_data['start_date']))) ?></div>
                                                                            <div class="col-md-3 text-muted">Contract Type</div>
                                                                            <div class="col-md-3"><?= htmlspecialchars($employees_data['contract_type']) ?></div>
                                                                        </div>
                                                                       
                                                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php else: ?>
                                                <div class="alert alert-info col-md-8">
                                                    <strong>Info:</strong> This is a system default user account. No employee profile is associated.
                                                </div>
                                            <?php endif; ?>


                                            <!-- Right Column: Leave Data and System Roles -->
                                            <div class="col-md-4">
                                                <div class="card">
                                                    <div class="card-header bg-success text-white">Leave Data</div>
                                                    <div class="card-body">
                                                        <?php if ($leave_data): ?>
                                                            <p><strong>Total days Allocated:</strong> <?= htmlspecialchars($leave_data['total_allocated']) ?></p>
                                                            <p><strong>Leave Taken:</strong> <?= htmlspecialchars($leave_data['total_approved']) ?></p>
                                                            <p><strong>Remaining Leave:</strong> <?= htmlspecialchars($leave_data['total_left']) ?></p>

                                                            <!-- Canvas for the Bar Chart -->
                                                            <canvas id="leaveChart"></canvas>
                                                        <?php else: ?>
                                                            <p>No leave data available.</p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>


                                                <div class="card mt-3">
                                                    <div class="card-header bg-warning text-dark">System Roles</div>
                                                    <div class="card-body">
                                                        <p><strong>Logged-in Role:</strong> <?= htmlspecialchars($_SESSION['sess_userrole']) ?></p>

                                                        <?php if ($is_supervisor): ?>
                                                            <p>Supervisor of Warehouse: <strong><?= htmlspecialchars($warehouse_name) ?></strong></p>
                                                        <?php endif; ?>

                                                        <?php if ($is_cashier): ?>
                                                            <p>Cashier/Shop Manager in Branch: <strong><?= htmlspecialchars($branch_name) ?></strong></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php include_once 'footer.php'; ?>
            </div>
        </div>

        <?php 
            include_once 'libraries.php';
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Data for the bar chart
                var leaveData = {
                    labels: ['Total Allocated', 'Leave Taken', 'Remaining Leave'],
                    datasets: [{
                        label: 'Leave Days',
                        data: [
                            <?= htmlspecialchars($leave_data['total_allocated']) ?>,
                            <?= htmlspecialchars($leave_data['total_approved']) ?>,
                            <?= htmlspecialchars($leave_data['total_left']) ?>
                        ],
                        backgroundColor: ['#28a745', '#ffc107', '#dc3545'], // Green, Yellow, Red
                        borderColor: ['#155724', '#856404', '#721c24'], // Darker shades for borders
                        borderWidth: 1
                    }]
                };

                // Bar Chart configuration
                var ctx = document.getElementById('leaveChart').getContext('2d');
                var leaveChart = new Chart(ctx, {
                    type: 'bar',
                    data: leaveData,
                    options: {
                        responsive: true,
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            legend: {
                                display: false // Hide legend if you don't need it
                            },
                            tooltip: {
                                callbacks: {
                                    label: function(tooltipItem) {
                                        return tooltipItem.raw + ' days'; // Add 'days' to each tooltip label
                                    }
                                }
                            }
                        }
                    }
                });
            });
        </script>
        
    </body>
    </html>
